

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
periods = ["Q1", "Q2", "Q3", "Q4"]  # Time periods to be treated as categories
existentialism = [10, 15, 20, 25]
rationalism = [12, 14, 15, 22]
empiricism = [8, 9, 12, 18]
pragmatism = [6, 10, 14, 15]
structuralism = [14, 16, 19, 23]
postmodernism = [20, 25, 22, 30]

# Axes Limits and Labels
xlabel_value = "Quarters"
ylabel_value = "Publication Count"
ylim_values = [0, 35]
yticks_values = np.arange(0, 36, 5)

# Labels
label_existentialism = "Existentialism"
label_rationalism = "Rationalism"
label_empiricism = "Empiricism"
label_pragmatism = "Pragmatism"
label_structuralism = "Structuralism"
label_postmodernism = "Postmodernism"
title='Philosophical Publications Over Time'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
plt.figure(figsize=(8, 5))
plt.plot(periods, existentialism, color='#76C1FA', linestyle='-', marker='o', linewidth=2, label=label_existentialism)
plt.plot(periods, rationalism, color='#4CAF50', linestyle='--', marker='^', linewidth=2, label=label_rationalism)
plt.plot(periods, empiricism, color='#FF9800', linestyle='-', marker='s', linewidth=2, label=label_empiricism)
plt.plot(periods, pragmatism, color='#F44336', linestyle=':', marker='d', linewidth=2, label=label_pragmatism)
plt.plot(periods, structuralism, color='#9C27B0', linestyle='-.', marker='x', linewidth=2, label=label_structuralism)
plt.plot(periods, postmodernism, color='#00BCD4', linestyle='-', marker='p', linewidth=2, label=label_postmodernism)

plt.yticks(yticks_values, fontsize=12)
plt.ylim(ylim_values)

# Set x-axis labels equidistantly
ax = plt.gca()
ax.set_xticks(np.arange(len(periods)))  # Positional indexing for equidistant spacing
ax.set_xticklabels(periods, fontsize=12)  # Labeling x-ticks as per periods

plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.title(title, fontsize=16)

plt.legend(
    loc="upper left", ncol=2, fontsize=10, columnspacing=1
)  # Adjusted legend settings

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("line_184.pdf", bbox_inches="tight")
