
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for each subplot (Example data generated for literature domain)
x = ["Jan", "Feb", "Mar", "Apr", "May", "Jun"]

# Monthly book sales for four different genres (thousands)
y1_0 = [10, 15, 20, 25, 30, 35]   # Genre 1 (Fiction)
y2_0 = [8, 12, 18, 22, 25, 30]    # Genre 2 (Non-Fiction)
y3_0 = [5, 10, 15, 20, 25, 30]    # Genre 3 (Sci-Fi)
y4_0 = [3, 5, 8, 10, 12, 15]      # Genre 4 (Biography)

# Physical vs Digital book sales (thousands)
y1_1 = [6, 8, 12, 15, 18, 22]     # Physical
y2_1 = [4, 7, 10, 12, 15, 18]     # Digital

# Seasonal book sales trends (thousands)
y1_2 = [8, 10, 12, 15, 18, 22]    # Spring
y2_2 = [6, 8, 10, 12, 14, 16]     # Summer
y3_2 = [4, 6, 8, 10, 12, 14]      # Autumn
y4_2 = [2, 4, 6, 7, 9, 11]        # Winter

# Average price per book (USD)
y1_3 = [10, 12, 14, 16, 18, 20]   # Fiction
y2_3 = [8, 10, 12, 14, 16, 18]    # Non-Fiction
y3_3 = [6, 8, 10, 12, 14, 16]     # Sci-Fi
y4_3 = [5, 7, 9, 11, 13, 15]      # Biography

# Axes Limits and Labels
xlim_values = [0, 6]
xticks_values = x

ylabel_value = "Book Sales (Thousands)"
ylim_values_1 = [0, 40]
yticks_values_1 = np.arange(0, 41, 10)
ylabel_2 = "Book Sales (Thousands)"
ylim_values_2 = [0, 25]
yticks_values_2 = np.arange(0, 26, 5)
ylabel_3 = "Book Sales (Thousands)"
ylim_values_3 = [0, 25]
yticks_values_3 = np.arange(0, 26, 5)
ylabel_4 = "Average Price (USD)"
ylim_values_4 = [0, 25]
yticks_values_4 = np.arange(0, 26, 5)

# Labels
label_1 = "Fiction"
label_2 = "Non-Fiction"
label_3 = "Sci-Fi"
label_4 = "Biography"

label_physical = "Physical"
label_digital = "Digital"
label_spring = "Spring"
label_summer = "Summer"
label_autumn = "Autumn"
label_winter = "Winter"

# Titles for each subplot
title_1 = "Monthly Book Sales by Genre"
title_2 = "Physical vs Digital Book Sales"
title_3 = "Seasonal Book Sales Trends"
title_4 = "Average Price per Book"

# Plot data on each subplot
datasets = ["Fiction", "Non-Fiction", "Sci-Fi", "Biography"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots
fig, axs = plt.subplots(1, 4, figsize=(20, 5))
# Color scheme (customized for literature theme)
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]

# Plot data on each subplot
axs[0].plot(x, y1_0, "o--", label=label_1, color=colors[0], markersize=10)
axs[0].plot(x, y2_0, "^--", label=label_2, color=colors[1], markersize=10)
axs[0].plot(x, y3_0, "s--", label=label_3, color=colors[2], markersize=10)
axs[0].plot(x, y4_0, "*--", label=label_4, color=colors[3], markersize=10)
axs[0].set_xticks(xticks_values)
axs[0].set_title(title_1, fontsize=14)
axs[0].set_ylabel(ylabel_value, fontsize=14)
axs[0].set_yticks(yticks_values_1)
axs[0].set_ylim(ylim_values_1)

axs[1].plot(x, y1_1, "o--", label=label_physical, color="#1f77b4", markersize=10)
axs[1].plot(x, y2_1, "^--", label=label_digital, color="#ff7f0e", markersize=10)
axs[1].set_xticks(xticks_values)
axs[1].set_title(title_2, fontsize=14)
axs[1].set_ylabel(ylabel_2, fontsize=14)
axs[1].set_yticks(yticks_values_2)
axs[1].set_ylim(ylim_values_2)

axs[2].plot(x, y1_2, "o--", label=label_spring, color=colors[0], markersize=10)
axs[2].plot(x, y2_2, "^--", label=label_summer, color=colors[1], markersize=10)
axs[2].plot(x, y3_2, "s--", label=label_autumn, color=colors[2], markersize=10)
axs[2].plot(x, y4_2, "*--", label=label_winter, color=colors[3], markersize=10)
axs[2].set_xticks(xticks_values)
axs[2].set_title(title_3, fontsize=14)
axs[2].set_ylabel(ylabel_3, fontsize=14)
axs[2].set_yticks(yticks_values_3)
axs[2].set_ylim(ylim_values_3)

axs[3].plot(x, y1_3, "o--", label=label_1, color=colors[0], markersize=10)
axs[3].plot(x, y2_3, "^--", label=label_2, color=colors[1], markersize=10)
axs[3].plot(x, y3_3, "s--", label=label_3, color=colors[2], markersize=10)
axs[3].plot(x, y4_3, "*--", label=label_4, color=colors[3], markersize=10)
axs[3].set_xticks(xticks_values)
axs[3].set_title(title_4, fontsize=14)
axs[3].set_ylabel(ylabel_4, fontsize=14)
axs[3].set_yticks(yticks_values_4)
axs[3].set_ylim(ylim_values_4)

plt.legend(loc="center", bbox_to_anchor=(-1.6, -0.2), ncol=4, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("line_187.pdf", bbox_inches="tight")
