
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
months = np.linspace(1, 12, 12)
rainfall_spring = np.random.normal(loc=75, scale=20, size=12).clip(0, 150)
rainfall_summer = np.random.normal(loc=120, scale=30, size=12).clip(0, 200)
rainfall_fall = np.random.normal(loc=70, scale=25, size=12).clip(0, 150)
rainfall_winter = np.random.normal(loc=30, scale=15, size=12).clip(0, 100)

# Labels and Plot Types
label_rainfall_spring = "Spring"
label_rainfall_summer = "Summer"
label_rainfall_fall = "Fall"
label_rainfall_winter = "Winter"

xticks_labels = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]

# Axes Limits and Labels
yticks_values = np.arange(0, 250, 25)
ylim_values = [-10, 250]
xlabel_value = "Month"
ylabel_value = "Rainfall (mm)"
title_value = "Average Monthly Rainfall for Seasons"
legend_labels = ["Spring", "Summer", "Fall", "Winter"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 6))  # Increased figure size for clarity
plt.plot(months, rainfall_spring, "-o", label=label_rainfall_spring, color="#66c2a5")
plt.fill_between(months, rainfall_spring - 20, rainfall_spring + 20, color="#66c2a5", alpha=0.2)
plt.plot(months, rainfall_summer, "--^", label=label_rainfall_summer, color="#fc8d62")
plt.fill_between(months, rainfall_summer - 30, rainfall_summer + 30, color="#fc8d62", alpha=0.2)
plt.plot(months, rainfall_fall, "-.x", label=label_rainfall_fall, color="#8da0cb")
plt.fill_between(months, rainfall_fall - 25, rainfall_fall + 25, color="#8da0cb", alpha=0.2)
plt.plot(months, rainfall_winter, ":s", label=label_rainfall_winter, color="#e78ac3")
plt.fill_between(months, rainfall_winter - 15, rainfall_winter + 15, color="#e78ac3", alpha=0.2)

# Customizing axes and labels (third-level elements)
plt.yticks(yticks_values, fontsize=12)
plt.xticks(months, xticks_labels, fontsize=12)
plt.ylim(ylim_values)
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.title(title_value, fontsize=16)
plt.grid(True, linestyle='--', linewidth=0.5)

# Relocating the legend to ensure no overlap with data lines
plt.legend(loc="upper left", frameon=True, shadow=True, fontsize=12, labels=legend_labels)

# Customizing the background (third-level element)
plt.gca().set_facecolor("#f4f4f5")
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("line_188.pdf", bbox_inches="tight")
