
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# New generated data
import numpy as np

np.random.seed(1)
terms = np.array(['Term 1', 'Term 2', 'Term 3', 'Term 4'])
math_scores = np.random.normal(loc=75, scale=10, size=4).clip(50, 100)
science_scores = np.random.normal(loc=70, scale=12, size=4).clip(40, 100)
english_scores = np.random.normal(loc=80, scale=8, size=4).clip(60, 100)
history_scores = np.random.normal(loc=65, scale=15, size=4).clip(30, 100)

# Labels and Plot Types
label_math = "Math"
label_science = "Science"
label_english = "English"
label_history = "History"

# Axes Limits and Labels
yticks_values = np.arange(30, 110, 10)
ylim_values = [30, 100]
xlabel_value = "Academic Terms"
ylabel_value = "Average Test Scores"
chart_title = "Average Test Scores Across Terms for Different Subjects"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting with error bars (second-level element)
plt.figure(figsize=(10, 6))  # Increased figure size for clarity
plt.plot(terms, math_scores, "-o", label=label_math, color="#2b83ba")
plt.fill_between(terms, math_scores - 10, math_scores + 10, color="#2b83ba", alpha=0.2)
plt.plot(terms, science_scores, "-s", label=label_science, color="#abdda4")
plt.fill_between(terms, science_scores - 12, science_scores + 12, color="#abdda4", alpha=0.2)
plt.plot(terms, english_scores, "--^", label=label_english, color="#fdae61")
plt.fill_between(terms, english_scores - 8, english_scores + 8, color="#fdae61", alpha=0.2)
plt.plot(terms, history_scores, "-.x", label=label_history, color="#d73027")
plt.fill_between(terms, history_scores - 15, history_scores + 15, color="#d73027", alpha=0.2)

# Customizing axes and labels (third-level elements)
plt.yticks(yticks_values, fontsize=12)
plt.xticks(fontsize=12)
plt.ylim(ylim_values)
plt.grid(True)

# Relocating the legend to ensure no overlap with data lines
plt.legend(loc="upper right", frameon=True, shadow=True,ncol=1, fontsize=10)

# Customizing the background (third-level element)
plt.gca().set_facecolor("#f4f4f5")
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)

# Labels
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.title(chart_title, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("line_189.pdf", bbox_inches="tight")
