
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Generate new data
np.random.seed(1)
doses = np.linspace(10, 50, 5)
control_group = np.random.normal(loc=2, scale=0.5, size=5).clip(1, 3)
low_dose = np.random.normal(loc=3, scale=0.8, size=5).clip(1.5, 4)
medium_dose = np.random.normal(loc=4.5, scale=1, size=5).clip(2, 6)
high_dose = np.random.normal(loc=6, scale=0.5, size=5).clip(3, 7)

# Labels and Plot Types
label_control_group = "No Fertilizer"
label_low_dose = "Low Fertilizer Dose"
label_medium_dose = "Medium Fertilizer Dose"
label_high_dose = "High Fertilizer Dose"

# Axes Limits and Labels
yticks_values = np.arange(1, 8, 1)
ylim_values = [1, 7]
xlabel_value = "Fertilizer Dose (kg/ha)"
ylabel_value = "Crop Yield (tons/ha)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting with error bars
plt.figure(figsize=(10, 7))  # Increased figure size for better readability
plt.plot(doses, control_group, "-o", label=label_control_group, color="#4c72b0")
plt.fill_between(doses, control_group - 0.5, control_group + 0.5, color="#4c72b0", alpha=0.2)
plt.plot(doses, low_dose, "-^", label=label_low_dose, color="#55a868")
plt.fill_between(doses, low_dose - 0.8, low_dose + 0.8, color="#55a868", alpha=0.2)
plt.plot(doses, medium_dose, "-s", label=label_medium_dose, color="#c44e52")
plt.fill_between(doses, medium_dose - 1, medium_dose + 1, color="#c44e52", alpha=0.2)
plt.plot(doses, high_dose, "-d", label=label_high_dose, color="#8172b2")
plt.fill_between(doses, high_dose - 0.5, high_dose + 0.5, color="#8172b2", alpha=0.2)

# Customizing axes and labels
plt.yticks(yticks_values, fontsize=12)
plt.xticks(fontsize=12)
plt.ylim(ylim_values)
plt.grid(True, linestyle='--', linewidth=0.5)

# Relocating the legend to ensure no overlap with data lines
plt.legend(loc="upper right",ncol=4, frameon=True, shadow=True, fontsize=10)

# Customizing the background
plt.gca().set_facecolor("#eaeaf2")
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)

# Labels
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("line_190.pdf", bbox_inches="tight")
