
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data: Yearly data from 2010 to 2020
years = np.array([2010, 2012, 2014, 2016, 2018, 2020])
social_media1_usage = np.array([70, 68, 65, 60, 55, 50])  # Facebook
social_media2_usage = np.array([30, 35, 40, 50, 55, 60])  # Instagram
social_media3_usage = np.array([25, 28, 30, 32, 33, 35])  # Twitter

# Polynomial trends for illustration
social_media2_trend = np.poly1d(np.polyfit(years, social_media2_usage, 2))(years)

# Axes Limits and Labels
xlabel_value = "Year"
ylabel_value_1 = "Percentage Usage"
ylabel_value_2 = "Trend Value"
yticks_values_1 = np.arange(0, 81, 10)
yticks_values_2 = np.arange(min(social_media2_trend)-5, max(social_media2_trend)+5, 5)

# Labels
label_1 = "Facebook"
label_2 = "Instagram"
label_3 = "Twitter"
label_4 = "Trend (Instagram)"
suptitle = "Social Media Usage and Trend Analysis"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

color_1 = "#8a2be2"
color_2 = "#3cb371"
color_3 = "#4682b4"
color_4 = "r"

# First subplot
ax1.plot(years, social_media1_usage, "D--", color=color_1, linewidth=2, label=label_1)
ax1.plot(years, social_media2_usage, "o-", color=color_2, linewidth=2, label=label_2)
ax1.set_xlabel(xlabel_value)
ax1.set_ylabel(ylabel_value_1)
ax1.set_xticks(years)
ax1.set_yticks(yticks_values_1)
ax1.legend(loc="best")
ax1.grid(True)

# Second subplot
ax2.plot(years, social_media3_usage, "s:", color=color_3, linewidth=2, label=label_3)
ax2.plot(years, social_media2_trend, "*-", color=color_4, linewidth=2, label=label_4)
ax2.set_xlabel(xlabel_value)
ax2.set_ylabel(ylabel_value_2)
ax2.set_xticks(years)
ax2.set_yticks(yticks_values_2)
ax2.legend(loc="best")
ax2.grid(True)

# Annotations and styling
for ax in (ax1, ax2):
    ax.spines["left"].set_position(("outward", 10))
    ax.spines["bottom"].set_position(("outward", 10))
    ax.spines["right"].set_color("none")
    ax.spines["top"].set_color("none")
for x, y in zip(years, social_media1_usage):
    ax1.annotate(
        f"{y}%", xy=(x, y), textcoords="offset points", xytext=(0, 10), ha="center"
    )

# Overall title and layout
fig.suptitle(suptitle, fontsize=16)
plt.tight_layout()
plt.subplots_adjust(top=0.9)

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("line_194.pdf", bbox_inches="tight")
