
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)
# Data: Influence score of three philosophers over time
time_steps = np.array([1, 2, 3, 4, 5])
influence_series_1 = np.array([70, 85, 90, 88, 95])  # Philosopher 1
influence_series_2 = np.array([60, 72, 75, 80, 85])  # Philosopher 2
influence_series_3 = np.array([65, 78, 83, 87, 92])  # Philosopher 3
poly_trend = np.poly1d(np.polyfit(time_steps, influence_series_2, 3))(time_steps)

# Axes Limits and Labels
xlabel_value = "Time Period (Years)"
ylabel_value_1 = "Influence Score Over Time"
ylabel_value_2 = "Polynomial Trend (Philosopher 2)"
yticks_values_1 = np.arange(50, 101, 10)
yticks_values_2 = np.arange(min(poly_trend), max(poly_trend) + 5, 5)

# Labels
label_1 = "Philosopher 1"
label_2 = "Philosopher 2"
label_3 = "Polynomial Trend (from Philosopher 2)"
label_4 = "Philosopher 3"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Colors
color_1 = '#FF5733'  # Orange
color_2 = '#33FF57'  # Green
color_3 = '#3357FF'  # Blue
color_4 = 'magenta'  # Magenta

# First subplot
ax1.plot(time_steps, influence_series_1, 'o-', color=color_1, label=label_1)  
ax1.plot(time_steps, influence_series_2, 's-', color=color_2, label=label_2)  
ax1.set_xlabel(xlabel_value)
ax1.set_ylabel(ylabel_value_1)
ax1.set_xticks(time_steps)
ax1.set_yticks(yticks_values_1)
ax1.legend(loc="upper left")
ax1.grid(True)

# Second subplot
ax2.plot(time_steps, influence_series_3, '^--', color=color_3, label=label_4)  
ax2.plot(time_steps, poly_trend, '*-', color=color_4, label=label_3)  
ax2.set_xlabel(xlabel_value)
ax2.set_ylabel(ylabel_value_2)
ax2.set_xticks(time_steps)
ax2.set_yticks(yticks_values_2)
ax2.legend(loc="upper right")
ax2.grid(True)

# Annotations and styling
for ax in (ax1, ax2):
    ax.spines["left"].set_position(("outward", 10))
    ax.spines["bottom"].set_position(("outward", 10))
    ax.spines["right"].set_color("none")
    ax.spines["top"].set_color("none")

for x, y in zip(time_steps, influence_series_1):
    ax1.annotate(
        f"{y}", xy=(x, y), textcoords="offset points", xytext=(0, 10), ha="center"
    )

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("line_195.pdf", bbox_inches="tight")
