
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Simulated Psychology Data
years = np.array(["2018", "2019", "2020", "2021", "2022", "2023"])
country_a = np.array([7.2, 7.5, 7.8, 7.9, 8.0, 8.2])
country_a_err = np.array([0.3, 0.4, 0.2, 0.3, 0.4, 0.3])
country_b = np.array([6.8, 7.0, 6.9, 7.1, 7.3, 7.5])
country_b_err = np.array([0.4, 0.3, 0.5, 0.4, 0.3, 0.4])
country_c = np.array([6.2, 6.3, 6.5, 6.7, 6.8, 7.0])
country_c_err = np.array([0.3, 0.4, 0.3, 0.4, 0.5, 0.4])
country_d = np.array([7.0, 7.2, 7.4, 7.6, 7.7, 7.9])
country_d_err = np.array([0.4, 0.3, 0.4, 0.3, 0.4, 0.3])

# Axes Limits and Labels
ylabel_value = "Average Happiness Score"
ylim_values = [4, 10]
yticks_values = np.arange(4, 11, 1)

# Labels
label_a = "Country A"
label_b = "Country B"
label_c = "Country C"
label_d = "Country D"

# Titles
title_1 = "Happiness Scores Over Years (Region 1)"
title_2 = "Happiness Scores Over Years (Region 2)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a subplot layout of 1x2
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 5), sharey=True)

# First subplot for Region 1
ax1.errorbar(
    years,
    country_a,
    yerr=country_a_err,
    fmt="o-",
    label=label_a,
    color="#1f77b4",
    capsize=5,
    linewidth=2
)
ax1.errorbar(
    years,
    country_b,
    yerr=country_b_err,
    fmt="^-",
    label=label_b,
    color="#ff7f0e",
    capsize=5,
    linewidth=2
)
ax1.set_title(title_1)
ax1.set_xticks(years)
ax1.set_xticklabels(years, rotation=45, ha="right", fontsize=12)
ax1.set_yticks(yticks_values)
ax1.set_ylim(ylim_values)
ax1.grid(True, which="both", linestyle="--", linewidth=0.5, alpha=0.5)
ax1.set_ylabel(ylabel_value, fontsize=16)
ax1.legend(loc="upper left", fontsize=12)

# Second subplot for Region 2
ax2.errorbar(
    years,
    country_c,
    yerr=country_c_err,
    fmt="s--",
    label=label_c,
    color="#2ca02c",
    capsize=5,
    linewidth=2
)
ax2.errorbar(
    years,
    country_d,
    yerr=country_d_err,
    fmt="o-.",
    label=label_d,
    color="#d62728",
    capsize=5,
    linewidth=2
)
ax2.set_title(title_2)
ax2.set_xticks(years)
ax2.set_xticklabels(years, rotation=45, ha="right", fontsize=12)
ax2.grid(True, which="both", linestyle="--", linewidth=0.5, alpha=0.5)
ax2.legend(loc="upper left", fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Enhance overall layout
plt.tight_layout()
plt.savefig("line_198.pdf", bbox_inches="tight")
