
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for plotting - Server performance metrics over 12 months
months = np.array([1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12])
cpu_usage = np.random.uniform(20, 80, len(months))  # CPU Usage in %
memory_usage = np.random.uniform(30, 90, len(months))  # Memory Usage in %
disk_io = np.random.uniform(100, 500, len(months))  # Disk I/O operations per second
network_traffic = np.random.uniform(50, 200, len(months))  # Network Traffic in Mbps

# Axes Limits and Labels
xlabel_value = "Months"
ylabel_value = "Values"
title_value = "Monthly Server Performance Metrics"

# Labels
label_CPU = "CPU Usage (%)"
label_Memory = "Memory Usage (%)"
label_DiskIO = "Disk I/O (ops/sec)"
label_NetworkTraffic = "Network Traffic (Mbps)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(10, 6))

# Plot the data using different styles and colors
plt.plot(
    months,
    cpu_usage,
    "o-",
    color="#ffa07a",
    label=label_CPU,
    markerfacecolor="#ffa07a",
    markersize=8,
    linewidth=2,
)
plt.plot(
    months,
    memory_usage,
    "s--",
    color="#3cb371",
    label=label_Memory,
    markersize=8,
    linewidth=2,
)
plt.plot(
    months,
    disk_io,
    "^-",
    color="#ff7f50",
    label=label_DiskIO,
    markersize=8,
    linewidth=2,
)
plt.plot(
    months,
    network_traffic,
    "d-.",
    color="#4682b4",
    label=label_NetworkTraffic,
    markersize=8,
    linewidth=2,
)

# Customize the x and y axes limits and labels
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.title(title_value, fontsize=16)
plt.xticks(months, labels=[str(m) for m in months])
plt.xlim(left=0.9, right=12.1)
plt.ylim(bottom=0, top=max(np.max(cpu_usage), np.max(memory_usage), np.max(disk_io), np.max(network_traffic)) * 1.1)

# Adjust the legend position
plt.legend(bbox_to_anchor=(1, 0.5), fontsize=12, frameon=True)

# Add grid lines for better readability
plt.grid(True, which="both", ls="--", color="grey", linewidth=1, alpha=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and save the plot
plt.tight_layout()
plt.savefig("line_202.pdf", bbox_inches="tight")
