
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# New data representing social media activities over a day
times = np.linspace(0, 24, 25)
posts = np.sin(times / 4) * 20 + np.random.normal(0, 5, len(times)) + 50
likes = np.cos(times / 3) * 25 + np.random.normal(0, 5, len(times)) + 100

# Extracted variables
line_label1 = "Number of Posts"
line_label2 = "Number of Likes"
xlim_values = (0, 24)
ylim_values = (0, 150)
xlabel_value = "Time (Hours)"
ylabel_value = "Activity Count"
yticks_values = [0, 25, 50, 75, 100, 125, 150]
title1 = "Daily Social Media Posts"
title2 = "Daily Social Media Likes"
legend_location = "upper right"
legend_bbox_to_anchor = (0.5, -0.2)
legend_frameon = False

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
fig, axs = plt.subplots(2, 1, figsize=(8, 12))

# Define new colors and markers for a fresh look
colors = ["deepskyblue", "forestgreen"]
linestyles = ["-", "--"]
labels = [line_label1, line_label2]

# First subplot for Number of Posts
axs[0].plot(times, posts, color=colors[0], linestyle=linestyles[0], label=labels[0])
axs[0].set_title(title1, fontsize=14)
axs[0].set_xlabel(xlabel_value, fontsize=12)
axs[0].set_ylabel(ylabel_value, fontsize=12)
axs[0].set_xlim(xlim_values)
axs[0].set_ylim(ylim_values)
axs[0].set_yticks(yticks_values)
axs[0].legend(loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon, fontsize=10)
axs[0].tick_params(axis="both", which="both", length=0)

# Second subplot for Number of Likes
axs[1].plot(times, likes, color=colors[1], linestyle=linestyles[1], label=labels[1])
axs[1].set_title(title2, fontsize=14)
axs[1].set_xlabel(xlabel_value, fontsize=12)
axs[1].set_ylabel(ylabel_value, fontsize=12)
axs[1].set_xlim(xlim_values)
axs[1].set_ylim(ylim_values)
axs[1].set_yticks(yticks_values)
axs[1].legend(loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon, fontsize=10)
axs[1].tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
# Enhance overall layout and visuals
plt.tight_layout()
plt.savefig("line_206.pdf", bbox_inches="tight")
