

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Generate new data for a philosophy scenario
eras = np.array(["Ancient", "Medieval", "Modern", "Contemporary"])  # Eras
published_papers = np.random.normal(100, 20, len(eras))  # Simulate the number of published papers
average_citations = 5 + 3 * np.log(np.arange(1, len(eras)+1))  # Simulate average citations per paper

# Axes Limits and Labels
xlabel_value = "Era"

ylabel_value_1 = "Number of Published Papers"
ylabel_value_2 = "Average Citations Per Paper"

# Labels
label_1 = "Number of Published Papers"
label_2 = "Average Citations Per Paper"

# Titles
title = "Publication and Citation Trends Across Different Eras in Philosophy"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax1 = plt.subplots(figsize=(10, 6))

# Plot published papers data with primary axis
color = "#1f77b4"  # Custom color for published papers
ax1.set_xlabel(xlabel_value)
ax1.set_ylabel(ylabel_value_1, color=color)
ax1.plot(eras, published_papers, label=label_1, color=color, marker="o", linestyle="-", linewidth=2)
ax1.tick_params(axis="y", labelcolor=color)
ax1.set_xticks(np.arange(len(eras)))
ax1.set_xticklabels(eras)
ax1.set_title(title, fontsize=14, fontweight='bold')

# Create a second y-axis for average citations
ax2 = ax1.twinx()  # Instantiate a second axes that shares the same x-axis
color = "#ff7f0e"  # Custom color for average citations
ax2.set_ylabel(ylabel_value_2, color=color)  # We already handled the x-label with ax1
ax2.plot(
    eras,
    average_citations,
    label=label_2,
    color=color,
    marker="s",
    linestyle="--",
    linewidth=2,
)
ax2.tick_params(axis="y", labelcolor=color)

# Add grid lines for better readability
ax1.grid(True)

# Add legends to the plot
lines, labels = ax1.get_legend_handles_labels()
lines2, labels2 = ax2.get_legend_handles_labels()
ax1.legend(lines + lines2, labels + labels2, loc="upper left", frameon=True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_213.pdf", bbox_inches="tight")

