
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Generate new data for health domain
months = np.arange(1, 13, 1)  # Months of the year
average_heart_rate = np.random.normal(70, 5, len(months))  # Simulate monthly average heart rate
average_blood_pressure = (
    80 + 10 * np.sin(0.5 * np.pi * months / 12) + np.random.normal(0, 5, len(months))
)  # Simulate monthly average blood pressure readings

# Axes Limits and Labels
xlabel_value = "Month"
ylabel_value_1 = "Average Heart Rate (bpm)"
ylabel_value_2 = "Average Blood Pressure (mmHg)"

# Labels
label_1 = "Monthly Average Heart Rate"
label_2 = "Monthly Average Blood Pressure"

# Titles
title = "Average Heart Rate and Blood Pressure Over a Year"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax1 = plt.subplots(figsize=(10, 6))

# Plot average heart rate data with primary axis
color1 = "#1f77b4"  # blue
ax1.set_xlabel(xlabel_value)
ax1.set_ylabel(ylabel_value_1, color=color1)
ax1.plot(months, average_heart_rate, label=label_1, color=color1, marker="o", linestyle="-", linewidth=2)
ax1.tick_params(axis="y", labelcolor=color1)
ax1.set_xticks(months)
ax1.set_title(title)

# Create a second y-axis for average blood pressure
ax2 = ax1.twinx()  # Instantiate a second axes that shares the same x-axis
color2 = "#ff7f0e"  # orange
ax2.set_ylabel(ylabel_value_2, color=color2)  # We already handled the x-label with ax1
ax2.plot(
    months,
    average_blood_pressure,
    label=label_2,
    color=color2,
    marker="s",
    linestyle="--",
    linewidth=2,
)
ax2.tick_params(axis="y", labelcolor=color2)

# Add legends to the plot
lines, labels = ax1.get_legend_handles_labels()
lines2, labels2 = ax2.get_legend_handles_labels()
ax1.legend(lines + lines2, labels + labels2, loc="upper left", frameon=True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_214.pdf", bbox_inches="tight")
