
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate new data for quarterly sales over time
quarters = np.linspace(1, 20, 20)
sales_data = np.sin(quarters/3) + np.random.normal(0, 0.1, 20) + 10  # Simulated sales data with noise
smoothed_sales = np.convolve(sales_data, np.ones(5) / 5, mode="valid")  # Smoothed data
change_in_sales = np.diff(sales_data)  # Change in sales data
cumulative_sales = np.cumsum(sales_data)  # Cumulative sales data

# Axes Limits and Labels
xlabel_value = "Business Quarters"

ylabel_value_1 = "Sales Volume"
ylabel_value_2 = "Change in Sales Volume"
ylabel_value_3 = "Cumulative Sales Volume"

# Labels
label_1 = "Smoothed Quarterly Sales"
label_2 = "Quarterly Change in Sales"
label_3 = "Cumulative Sales Volume"

# Titles
title_1 = "Smoothed Quarterly Sales Trends"
title_2 = "Quarterly Change in Sales Volume"
title_3 = "Cumulative Sales Volume Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a 3-subplot layout
fig, axs = plt.subplots(3, 1, figsize=(5, 10))

# First subplot: Smoothed Data
axs[0].plot(quarters[2:-2], smoothed_sales, label=label_1, color="#8B4513", linestyle="--", marker="D")
axs[0].set_title(title_1)
axs[0].set_ylabel(ylabel_value_1)
axs[0].legend(loc="upper right")
axs[0].grid(True, linestyle="--", alpha=0.5)

# Second subplot: Change in Sales Data
axs[1].plot(quarters[1:], change_in_sales, label=label_2, color="#4682B4", linestyle="-.", marker="o")
axs[1].set_title(title_2)
axs[1].set_ylabel(ylabel_value_2)
axs[1].legend(loc="upper right")
axs[1].grid(True, linestyle="--", alpha=0.5)

# Third subplot: Cumulative Sales Data
axs[2].plot(quarters, cumulative_sales, label=label_3, color="#556B2F", linestyle=":", marker="x")
axs[2].set_title(title_3)
axs[2].set_xlabel(xlabel_value)
axs[2].set_ylabel(ylabel_value_3)
axs[2].legend(loc="upper right")
axs[2].grid(True, linestyle="--", alpha=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_218.pdf", bbox_inches="tight")

