
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================

import numpy as np

np.random.seed(0)

# Timeline (Years)
t = np.arange(2000, 2021, 1)

# New Data
tourists = np.random.normal(loc=3, scale=1.5, size=len(t)).cumsum() + 500  # In thousands
revenue = np.random.normal(loc=15, scale=5, size=len(t)).cumsum() + 200  # In $ millions
occupancy = np.random.uniform(low=60, high=100, size=len(t))  # In %
flights = np.random.poisson(lam=30, size=len(t)).cumsum() + 800  # Number of flights

# Labels for legend
label_tourists = "Number of Tourists"
label_revenue = "Tourism Revenue"
label_occupancy = "Hotel Occupancy Rate"
label_flights = "Number of Flights"

# Plot configuration
xlim_values = (2000, 2020)
ylim_values_tourists = (500, 650)
ylim_values_revenue = (200, 600)
ylim_values_occupancy = (60, 100)
ylim_values_flights = (800, 1500)

xlabel_value = "Year"
ylabel_value_tourists = "Tourists (in thousands)"
ylabel_value_revenue = "Revenue (in $ millions)"
ylabel_value_occupancy = "Occupancy Rate (%)"
ylabel_value_flights = "Flights"

title_tourists = "Number of Tourists Over Time"
title_revenue = "Tourism Revenue Over Time"
title_occupancy = "Hotel Occupancy Rate Over Time"
title_flights = "Number of Flights Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axs = plt.subplots(4, 1, figsize=(8, 16))

# Colors
color_tourists = "#8E44AD"
color_revenue = "#2980B9"
color_occupancy = "#27AE60"
color_flights = "#C0392B"

# Plot Tourists
axs[0].plot(t, tourists, label=label_tourists, color=color_tourists, linestyle='-', marker='o')
axs[0].set_xlim(*xlim_values)
axs[0].set_ylim(*ylim_values_tourists)
axs[0].set_title(title_tourists, y=1.1)
axs[0].set_xlabel(xlabel_value)
axs[0].set_ylabel(ylabel_value_tourists)

# Plot Revenue
axs[1].plot(t, revenue, label=label_revenue, color=color_revenue, linestyle='--', marker='x')
axs[1].set_xlim(*xlim_values)
axs[1].set_ylim(*ylim_values_revenue)
axs[1].set_title(title_revenue, y=1.1)
axs[1].set_xlabel(xlabel_value)
axs[1].set_ylabel(ylabel_value_revenue)

# Plot Occupancy
axs[2].plot(t, occupancy, label=label_occupancy, color=color_flights, linestyle='-.', marker='s')
axs[2].set_xlim(*xlim_values)
axs[2].set_ylim(*ylim_values_occupancy)
axs[2].set_title(title_occupancy, y=1.1)
axs[2].set_xlabel(xlabel_value)
axs[2].set_ylabel(ylabel_value_occupancy)

# Plot Flights
axs[3].plot(t, flights, label=label_flights, color=color_occupancy, linestyle=':', marker='d')
axs[3].set_xlim(*xlim_values)
axs[3].set_ylim(*ylim_values_flights)
axs[3].set_title(title_flights, y=1.1)
axs[3].set_xlabel(xlabel_value)
axs[3].set_ylabel(ylabel_value_flights)

# Legend configuration
for ax in axs.flat:
    ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), frameon=False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("line_221.pdf", bbox_inches="tight")
