

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# New datasets based on historical events
years = np.linspace(1900, 2020, 21)  # Years from 1900 to 2020

# Data series
population_growth = np.cumsum(np.random.normal(1, 0.5, years.size))  # Gradual increase
tech_advancements = np.sin(years / 10) + np.random.normal(0, 1, years.size)  # Fluctuations
political_stability = np.sign(np.sin(years / 5)) * np.random.normal(50, 10, years.size)  # Sharp changes
economic_development = 1 / (1 + np.exp(-0.03 * (years - 2000))) * 100  # Steady rise

# Labels for legend
label_population = "Population Growth"
label_technology = "Technological Advancements"
label_political = "Political Stability"
label_economic = "Economic Development"

# Plot configuration
xlim_values = (1900, 2020)
ylim_values_population_tech_political = (-100, 200)
ylim_values_economic = (0, 120)

xlabel_value = "Year"
ylabel_value_general = "Index"
ylabel_value_economic = "Development (%)"

title_population = "Trends in Population Growth"
title_technology = "Technological Advancements Overtime"
title_political = "Political Stability Index"
title_economic = "Economic Development Trend"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axs = plt.subplots(4, 1, figsize=(6, 12))

color_population = "#2E91E5"
color_technology = "#E15F99"
color_political = "#1CA71C"
color_economic = "#FB0D0D"

axs[0].plot(years, population_growth, label=label_population, linestyle='-', linewidth=2, color=color_population)
axs[0].set_xlim(*xlim_values)
axs[0].set_ylim(*ylim_values_population_tech_political)
axs[0].set_title(title_population, y=1.1)
axs[0].set_xlabel(xlabel_value)
axs[0].set_ylabel(ylabel_value_general)

axs[1].plot(years, tech_advancements, label=label_technology, linestyle='--', linewidth=2, color=color_technology)
axs[1].set_xlim(*xlim_values)
axs[1].set_ylim(*ylim_values_population_tech_political)
axs[1].set_title(title_technology, y=1.1)
axs[1].set_xlabel(xlabel_value)
axs[1].set_ylabel(ylabel_value_general)

axs[2].plot(years, political_stability, label=label_political, linestyle='-.', linewidth=2, color=color_political)
axs[2].set_xlim(*xlim_values)
axs[2].set_ylim(*ylim_values_population_tech_political)
axs[2].set_title(title_political, y=1.1)
axs[2].set_xlabel(xlabel_value)
axs[2].set_ylabel(ylabel_value_general)

axs[3].plot(years, economic_development, label=label_economic, linestyle=':', linewidth=2, color=color_economic)
axs[3].set_xlim(*xlim_values)
axs[3].set_ylim(*ylim_values_economic)
axs[3].set_title(title_economic, y=1.1)
axs[3].set_xlabel(xlabel_value)
axs[3].set_ylabel(ylabel_value_economic)

for ax in axs.flat:
    ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), frameon=False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("line_223.pdf", bbox_inches="tight")

