
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for philosophy domain
decades = np.array([1950, 1960, 1970, 1980, 1990, 2000, 2010, 2020])
popularity_schools = np.array([20, 30, 40, 35, 50, 60, 70, 80])
popularity_schools_error = np.array([2, 3, 4, 3, 5, 6, 5, 4])

publication_frequency = np.array([10, 15, 20, 30, 40, 60, 70, 80])
publication_frequency_error = np.array([1, 2, 2, 3, 4, 5, 4, 3])

citation_impact = np.array([5, 10, 15, 10, 20, 25, 35, 40])
citation_impact_error = np.array([0.5, 1, 1.5, 1, 2, 2.5, 3, 4])

topic_diversity = np.array([10, 12, 15, 17, 20, 25, 30, 35])
topic_diversity_error = np.array([1, 1.2, 1.5, 1.7, 2, 2.5, 3, 3.5])

# Titles
titles = [
    "(a) Popularity of Philosophical Schools",
    "(b) Publication Frequency in Philosophy Journals",
    "(c) Citation Impact of Philosophical Works",
    "(d) Diversity of Philosophical Topics"
]

# Axis labels
xlabel = "Decade"
ylabel_popularity = "Popularity (%)"
ylabel_publication = "Publications (per decade)"
ylabel_citation = "Citation Impact"
ylabel_diversity = "Diversity Index"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Create 2x2 subplots
fig, axs = plt.subplots(2, 2, figsize=(10, 8))

# Flatten the axis array for easy iteration
axs = axs.flatten()

# Setting data for each subplot
data = [
    (decades, popularity_schools, popularity_schools_error, ylabel_popularity), 
    (decades, publication_frequency, publication_frequency_error, ylabel_publication), 
    (decades, citation_impact, citation_impact_error, ylabel_citation), 
    (decades, topic_diversity, topic_diversity_error, ylabel_diversity)
]

# Custom colors
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]

# Plot with error bars in each subplot
for ax, (x, y, e, ylabel), title, color in zip(axs, data, titles, colors):
    ax.errorbar(x, y, yerr=e, fmt="--s", color=color, ecolor="gray", capsize=8, markersize=8, markerfacecolor="white")
    ax.set_title(title, fontsize=16)
    ax.set_xlabel(xlabel, fontsize=14)
    ax.set_ylabel(ylabel, fontsize=14)
    ax.grid(True, alpha=0.5)
    ax.set_xticks(x)
    ax.set_yticks(np.linspace(min(y) - min(e), max(y) + max(e), num=5, endpoint=True))

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("line_225.pdf", bbox_inches="tight")
