

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data related to scientific research metrics
years = np.array([2010, 2012, 2014, 2016, 2018, 2020])
grant_funding = np.random.uniform(10, 60, size=len(years))
grant_funding_error = np.random.uniform(1, 3, size=len(years))

paper_counts = np.array([50, 100, 150, 200, 250, 300])
papers_published = np.random.uniform(30, 300, size=len(paper_counts))
papers_published_error = np.random.uniform(5, 20, size=len(paper_counts))

citation_years = np.array([1, 2, 3, 4, 5, 6])
citation_count = np.random.uniform(10, 70, size=len(citation_years))
citation_count_error = np.random.uniform(2, 10, size=len(citation_years))

conference_years = np.array([1, 2, 3, 4, 5, 6])
attendance_conferences = np.random.uniform(50, 200, size=len(conference_years))
attendance_conferences_error = np.random.uniform(5, 20, size=len(conference_years))

collaboration_years = np.array([1, 2, 3, 4, 5, 6])
collaboration_rate = np.random.uniform(10, 50, size=len(collaboration_years))
collaboration_rate_error = np.random.uniform(2, 10, size=len(collaboration_years))

satisfaction_years = np.array([1, 2, 3, 4, 5, 6])
satisfaction_level = np.random.uniform(60, 100, size=len(satisfaction_years))
satisfaction_level_error = np.random.uniform(3, 10, size=len(satisfaction_years))

# Titles and labels
titles = [
    "Grant Funding Over Years",
    "Papers Published Over Years",
    "Citation Count Over Years",
    "Conference Attendance Over Years",
    "Research Collaboration Rate",
    "Researcher Satisfaction Level",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create 2x3 subplots for a unified visual presentation
fig, axs = plt.subplots(2, 3, figsize=(15, 10))

colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b"]

data_pairs = [
    (years, grant_funding, grant_funding_error),
    (paper_counts, papers_published, papers_published_error),
    (citation_years, citation_count, citation_count_error),
    (conference_years, attendance_conferences, attendance_conferences_error),
    (collaboration_years, collaboration_rate, collaboration_rate_error),
    (satisfaction_years, satisfaction_level, satisfaction_level_error),
]

for ax, (x, y, e), title, color in zip(axs.flat, data_pairs, titles, colors):
    ax.errorbar(
        x, y, yerr=e, fmt="-o", color=color, ecolor="lightgray", capsize=5, label=title
    )
    ax.set_title(title)
    ax.set_xlabel("X Axis Label", fontsize=10)
    ax.set_ylabel("Y Axis Label", fontsize=10)
    ax.set_xticks(x)
    ax.set_ylim(min(y) - min(e) - 4, max(y) + max(e) + 4)
    ax.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no overlap and labels are clearly visible
plt.tight_layout()
plt.savefig("line_228.pdf", bbox_inches="tight")
