
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data setup for company revenue over five quarters
quarters = np.array([1, 2, 3, 4, 5])
company_A_revenue = np.array([15.2, 16.8, 17.5, 18.3, 19.0])
company_B_revenue = np.array([14.8, 15.5, 16.0, 16.8, 17.5])
company_C_revenue = np.array([13.0, 13.5, 14.2, 14.8, 15.3])
company_D_revenue = np.array([12.5, 13.0, 13.5, 14.0, 14.5])

# Axes Limits and Labels
xlabel_value = "Quarters"
xlim_values = [0, 6]
ylabel_value = "Revenue ($ millions)"
ylim_values = [12, 20]

# Labels for the chart
label_A = "Company A"
label_B = "Company B"
label_C = "Company C"
label_D = "Company D"

# Titles
title_1 = "Company A Revenue"
title_2 = "Company B Revenue"
title_3 = "Company C & Company D Revenue"

# Legend Labels
legend_labels = ["Company A", "Company B", "Company C", "Company D"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Define a custom color palette
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]

# Create the 1x3 subplot configuration
fig, axs = plt.subplots(1, 3, figsize=(9, 3))

# Plot customization for a polished look
marker_styles = ["o", "s", "D", "^"]
line_styles = ["-", "--", "-.", ":"]

# First subplot for Company A
axs[0].plot(
    quarters,
    company_A_revenue,
    label=label_A,
    color=colors[0],
    marker=marker_styles[0],
    linestyle=line_styles[0],
    markersize=8,
    linewidth=2,
)
axs[0].set_title(title_1, fontsize=14)
axs[0].set_xlabel(xlabel_value, fontsize=12)
axs[0].set_ylabel(ylabel_value, fontsize=12)

# Second subplot for Company B
axs[1].plot(
    quarters,
    company_B_revenue,
    label=label_B,
    color=colors[1],
    marker=marker_styles[1],
    linestyle=line_styles[1],
    markersize=8,
    linewidth=2,
)
axs[1].set_title(title_2, fontsize=14)
axs[1].set_xlabel(xlabel_value, fontsize=12)
axs[1].set_ylabel(ylabel_value, fontsize=12)

# Third subplot for Company C & Company D
axs[2].plot(
    quarters,
    company_C_revenue,
    label=label_C,
    color=colors[2],
    marker=marker_styles[2],
    linestyle=line_styles[2],
    markersize=8,
    linewidth=2,
)
axs[2].plot(
    quarters,
    company_D_revenue,
    label=label_D,
    color=colors[3],
    marker=marker_styles[3],
    linestyle=line_styles[3],
    markersize=8,
    linewidth=2,
)
axs[2].set_title(title_3, fontsize=14)
axs[2].set_xlabel(xlabel_value, fontsize=12)
axs[2].set_ylabel(ylabel_value, fontsize=12)

# Set global properties and customize each subplot individually
for ax in axs:
    ax.set_xticks(quarters)
    ax.set_xlim(xlim_values)
    ax.set_ylim(ylim_values)
    ax.legend(loc="upper left", fontsize=10)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no overlap and labels are clearly visible
plt.tight_layout()

# Show the plot
plt.savefig("line_238.pdf", bbox_inches="tight")
