

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Simulated transportation data
travel_duration = [1, 2, 3, 4]  # Travel duration in hours
avg_speed_city = np.array([40, 45, 50, 55])  # Average speed in km/h for city travel
avg_speed_highway = np.array([60, 70, 80, 90])  # Average speed in km/h for highway travel
efficiency_city = np.array([12, 11, 10, 9])  # Fuel efficiency in km/l for city travel
efficiency_highway = np.array([18, 17, 16, 15])  # Fuel efficiency in km/l for highway travel

# Axes Limits and Labels
xlabel_value = "Travel Duration (hours)"
ylabel_value_speed = "Average Speed (km/h)"
ylabel_value_efficiency = "Fuel Efficiency (km/l)"

# Labels
label_speed = "Average Speed"
label_efficiency = "Fuel Efficiency"
label_city = " (City Travel)"
label_highway = " (Highway Travel)"
title_speed_vs_duration = "Speed vs. Travel Duration"
title_efficiency_vs_duration = "Efficiency vs. Travel Duration"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with a 2x2 grid
fig, axs = plt.subplots(2, 2, figsize=(12, 9))

# Custom colors for the transportation theme
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]

# Function to plot the data
def plot_data(ax, x, y1, y2, title, ylabel, marker1, marker2, color1, color2, label1, label2):
    ax.plot(
        x,
        y1,
        marker=marker1,
        markersize=8,
        linewidth=2,
        linestyle='--',
        color=color1,
        label=label1,
    )
    ax.plot(
        x,
        y2,
        marker=marker2,
        markersize=8,
        linewidth=2,
        linestyle='-',
        color=color2,
        label=label2,
    )
    ax.set_title(title, fontsize=14)
    ax.set_xlabel(xlabel_value, fontsize=12)
    ax.set_ylabel(ylabel, fontsize=12)
    ax.legend(loc="best", fontsize=10, frameon=True, shadow=True)
    ax.grid(True, linestyle="--", alpha=0.5)

# Assigning data to each subplot
plot_data(
    axs[0, 0],
    travel_duration,
    avg_speed_city,
    avg_speed_highway,
    title_speed_vs_duration,
    ylabel_value_speed,
    "o",
    "s",
    colors[0],
    colors[1],
    f"{label_speed}{label_city}",
    f"{label_speed}{label_highway}",
)
plot_data(
    axs[0, 1],
    travel_duration,
    efficiency_city,
    efficiency_highway,
    title_efficiency_vs_duration,
    ylabel_value_efficiency,
    "^",
    "d",
    colors[2],
    colors[3],
    f"{label_efficiency}{label_city}",
    f"{label_efficiency}{label_highway}",
)
plot_data(
    axs[1, 0],
    travel_duration,
    avg_speed_highway,
    avg_speed_city,
    title_speed_vs_duration,
    ylabel_value_speed,
    "p",
    "*",
    colors[1],
    colors[0],
    f"{label_speed}{label_highway}",
    f"{label_speed}{label_city}",
)
plot_data(
    axs[1, 1],
    travel_duration,
    efficiency_highway,
    efficiency_city,
    title_efficiency_vs_duration,
    ylabel_value_efficiency,
    "H",
    "X",
    colors[3],
    colors[2],
    f"{label_efficiency}{label_highway}",
    f"{label_efficiency}{label_city}",
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plots
plt.tight_layout()
plt.savefig("line_241.pdf", bbox_inches="tight")

