
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Data for the plot
# Simulating number of tourists visiting two cities over a certain period
days = np.linspace(0, 200, 50)
city_a_tourists = 20000 * (1 + np.random.normal(0, 0.05, 50)).cumprod()
city_b_tourists = 15000 * (1 + np.random.normal(0, 0.04, 50)).cumprod()

# Axes Limits and Labels
xlabel_value = "Time (Days)"
ylabel_value = "Number of Tourists"
ylim_values = [1000, 40000]

# Labels
label_City_A = "City A"
label_City_B = "City B"

# Titles
title = "Tourist Numbers Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Customization options
color_a = "forestgreen"
color_b = "darkorange"
marker_a = "^"
marker_b = "s"
style_a = "--"
style_b = "-."

# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 5))

# Plot the data
ax.plot(
    days,
    city_a_tourists,
    label=label_City_A,
    color=color_a,
    marker=marker_a,
    markersize=6,
    linestyle=style_a,
    linewidth=2,
)
ax.plot(
    days,
    city_b_tourists,
    label=label_City_B,
    color=color_b,
    marker=marker_b,
    markersize=6,
    linestyle=style_b,
    linewidth=2,
)

# Enhance the plot with a title, labels, and legend
ax.set_title(title, fontsize=14, fontweight='bold')
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)

# Add a legend to the plot
ax.set_ylim(ylim_values)
ax.legend(loc="upper left", frameon=True, shadow=True, fontsize=10)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Save the plot
plt.savefig("line_245.pdf", bbox_inches="tight")
