

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for the plot
months = np.linspace(1, 12, 12)
city1_temps = np.random.normal(20, 5, 12)  # Average temperatures for City 1
city2_temps = np.random.normal(15, 7, 12)  # Average temperatures for City 2

# Axes Limits and Labels
xlabel_value = "Months"
ylabel_value = "Average Temperature (°C)"
ylim_values = [min(city1_temps.min(), city2_temps.min()) - 5, max(city1_temps.max(), city2_temps.max()) + 5]

# Labels
label_City1_Model = "City A Average Temperature"
label_City2_Model = "City B Average Temperature"

# Titles
title = "Average Monthly Temperature Comparison Over a Year"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Customization options
color_city1 = "forestgreen"
color_city2 = "royalblue"
marker_city1 = "s"
marker_city2 = "^"
style_city1 = "--"
style_city2 = "-."

# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 5))

# Plot the data
ax.plot(
    months,
    city1_temps,
    label=label_City1_Model,
    color=color_city1,
    marker=marker_city1,
    markersize=5,
    linestyle=style_city1,
    linewidth=2,
)
ax.plot(
    months,
    city2_temps,
    label=label_City2_Model,
    color=color_city2,
    marker=marker_city2,
    markersize=5,
    linestyle=style_city2,
    linewidth=2,
    alpha=0.8,
)

# Enhance the plot with a title, labels, and legend
ax.set_title(title)
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.grid(True, which='both', linestyle='--', linewidth=0.5)

# Add a legend to the plot
ax.set_ylim(ylim_values)
ax.legend(loc="upper left", frameon=True, shadow=True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Save the plot
plt.savefig("line_246.pdf", bbox_inches="tight")
