
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for the plot
weeks = np.arange(1, 29)
training_hours = np.sin(2 * np.pi * weeks / len(weeks)) * 3 + 8 + np.random.normal(0, 0.5, len(weeks))
distance_covered = np.cos(3 * np.pi * weeks / len(weeks)) * 10 + 50 + np.random.normal(0, 5, len(weeks))

# Axes Limits and Labels
xlabel_value = "Weeks"
ylabel_value_1 = "Training Hours"
ylabel_value_2 = "Distance Covered (km)"
ylim_values_training = [4, 12]
ylim_values_distance = [30, 70]

# Labels
label_1 = "Training Hours"
label_2 = "Distance Covered"

# Titles
title = "Athlete Performance: Training Hours and Distance Covered Over Weeks"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax1 = plt.subplots(figsize=(10, 6))

# Plot the data on the primary y-axis (Training Hours)
color = "seagreen"
ax1.set_xlabel(xlabel_value)
ax1.set_ylabel(ylabel_value_1, color=color)
ax1.plot(weeks, training_hours, label=label_1, color=color, marker="o", linestyle="-")
ax1.tick_params(axis="y", labelcolor=color)
ax1.set_ylim(ylim_values_training)

# Create a secondary y-axis and plot the data (Distance Covered)
ax2 = ax1.twinx()
color = "darkorange"
ax2.set_ylabel(ylabel_value_2, color=color)
ax2.plot(weeks, distance_covered, label=label_2, color=color, marker="x", linestyle="--")
ax2.tick_params(axis="y", labelcolor=color)
ax2.set_ylim(ylim_values_distance)

# Add a legend to the plot
ax1.legend(loc="upper left")
ax2.legend(loc="upper right")

# Customize the plot with a title, grid, and background color
ax1.set_facecolor("whitesmoke")
ax1.grid(True, which="both", linestyle="--", linewidth=0.5, alpha=0.7)

# Set the title
plt.title(title, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()
plt.savefig("line_248.pdf", bbox_inches="tight")
