
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

weeks = np.arange(1, 29)
temperature = 50 + 10 * np.sin(2 * np.pi * weeks / len(weeks)) + np.random.normal(0, 3, len(weeks))
humidity = 60 + 15 * np.cos(3 * np.pi * weeks / len(weeks)) + np.random.normal(0, 5, len(weeks))

# Calculate the upper and lower bounds for the data
temperature_upper = temperature + 4
temperature_lower = temperature - 4
humidity_upper = humidity + 8
humidity_lower = humidity - 8

# Axes Limits and Labels
xlabel_value = "Weeks"
ylabel_value = "Weather Metrics"

# Labels
label_temperature = "Temperature (°F)"
label_humidity = "Humidity (%)"

# Titles
title = "Temperature and Humidity Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 5))

# Plot the temperature data line and fill the confidence interval
ax.plot(
    weeks,
    temperature,
    label=label_temperature,
    color="green",
    marker="o",
    linestyle="-",
    linewidth=2,
)
ax.fill_between(
    weeks, temperature_lower, temperature_upper, color="green", alpha=0.3
)

# Plot the humidity data line and fill the confidence interval
ax.plot(
    weeks,
    humidity,
    label=label_humidity,
    color="red",
    marker="x",
    linestyle="--",
    linewidth=2,
)
ax.fill_between(weeks, humidity_lower, humidity_upper, color="red", alpha=0.3)

# Customize the plot with labels, title, and legend
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)
ax.set_title(title, fontsize=16)
ax.legend(fontsize=10)

# Add a grid to the plot
ax.grid(True, linestyle="--", linewidth=0.5, alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()
plt.savefig("line_251.pdf", bbox_inches="tight")
