

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Generate synthetic data for an art gallery
weeks = np.arange(1, 29)
gallery_visitors = np.linspace(200, 800, len(weeks)) + np.random.normal(0, 50, len(weeks))
installation_costs = np.linspace(1000, 5000, len(weeks)) + np.random.normal(0, 200, len(weeks))

# Calculate the upper and lower bounds for the data (confidence intervals)
visitors_upper = gallery_visitors + 100
visitors_lower = gallery_visitors - 100
costs_upper = installation_costs + 300
costs_lower = installation_costs - 300

# Axes Limits and Labels
xlabel_value = "Weeks"
ylabel_value = "Values"

# Labels
labelVisitors = "Gallery Visitors"
labelCosts = "Art Installation Costs"

# Titles
title = "Gallery Visitors and Art Installation Costs Analysis"
legendTitle = "Legend"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Plot the gallery visitors data line and fill the confidence interval
ax.plot(
    weeks,
    gallery_visitors,
    label=labelVisitors,
    color="forestgreen",
    marker="o",
    linestyle="-",
    linewidth=2,
)
ax.fill_between(
    weeks, visitors_lower, visitors_upper, color="forestgreen", alpha=0.3
)

# Plot the art installation costs data line and fill the confidence interval
ax.plot(
    weeks,
    installation_costs,
    label=labelCosts,
    color="darkorange",
    marker="d",
    linestyle="--",
    linewidth=2,
)
ax.fill_between(weeks, costs_lower, costs_upper, color="darkorange", alpha=0.3)

# Customize the plot with labels, title, and legend
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_title(title, fontsize=16)
ax.legend(loc="best", title=legendTitle)

# Add a grid to the plot
ax.grid(True, linestyle="--", linewidth=0.5, alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()
plt.savefig("line_253.pdf", bbox_inches="tight")

