
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.colors as mcolors

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# New data simulating population growth trends over time
years = list(range(2000, 2020))
population_region1 = [1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2.0, 2.1, 2.2, 2.3, 2.4, 2.5, 2.6, 2.7, 2.8, 2.9, 3.0, 3.1]
population_region2 = [0.8, 0.85, 0.9, 0.95, 1.0, 1.05, 1.1, 1.15, 1.2, 1.25, 1.3, 1.35, 1.4, 1.45, 1.5, 1.55, 1.6, 1.65, 1.7, 1.75]
population_region3 = [0.6, 0.65, 0.7, 0.75, 0.8, 0.85, 0.9, 0.95, 1.0, 1.05, 1.1, 1.15, 1.2, 1.25, 1.3, 1.35, 1.4, 1.45, 1.5, 1.55]
population_region4 = [1.0, 1.05, 1.1, 1.15, 1.2, 1.25, 1.3, 1.35, 1.4, 1.45, 1.5, 1.55, 1.6, 1.65, 1.7, 1.75, 1.8, 1.85, 1.9, 1.95]

# Labels and plot types
line_label_region1 = "Region 1"
line_label_region2 = "Region 2"
line_label_region3 = "Region 3"
line_label_region4 = "Region 4"

# Plot configuration
xlim_values = [2000, 2019]
ylim_values = [0, 4]
xlabel_value = "Year"
ylabel_value = "Population (Billions)"
xticks_values = np.arange(2000, 2020, 1)
yticks_values = np.arange(0, 4.1, 0.5)
xtickslabel_values = None  # Not explicitly set in the code
ytickslabel_values = None  # Not explicitly set in the code
title_value = None  # Not explicitly set in the code
axhiline_values = None  # Not explicitly set in the code
axvline_values = None  # Not explicitly set in the code

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
plt.figure(figsize=(12, 6))

plt.plot(
    years,
    population_region1,
    marker="o",
    markersize=8,
    color="#007f5f",
    clip_on=False,
    zorder=10,
    mfc="w",
    mew=2,
    label=line_label_region1,
    linewidth=2.5,
    linestyle="-",
)
plt.plot(
    years,
    population_region2,
    marker="s",
    markersize=8,
    color="#2b9348",
    clip_on=False,
    zorder=10,
    mfc="w",
    mew=2,
    label=line_label_region2,
    linewidth=2.5,
    linestyle="--",
)
plt.plot(
    years,
    population_region3,
    marker="^",
    markersize=8,
    color="#55a630",
    clip_on=False,
    zorder=10,
    mfc="w",
    mew=2,
    label=line_label_region3,
    linewidth=2.5,
    linestyle="-.",
)
plt.plot(
    years,
    population_region4,
    marker="D",
    markersize=8,
    color="#80b918",
    clip_on=False,
    zorder=10,
    mfc="w",
    mew=2,
    label=line_label_region4,
    linewidth=2.5,
    linestyle=":",
)

# Customize the plot with labels, title, and legend
plt.yticks(yticks_values)
plt.ylim(ylim_values)  # Adjusted y-axis limit

# Customize the x-axis ticks
plt.xticks(xticks_values)  # Ticks from 1 to 20, interval of 1
plt.xlim(xlim_values)  # Slightly beyond 1 and 20 for a margin

# Add a grid to the plot
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)
plt.tick_params(axis="x", which="both", length=0)
# Add a title to the plot
plt.legend(
    frameon=False,
    fontsize=12,
    loc="upper right",
    borderpad=1,
    ncol=4,
    bbox_to_anchor=(1, 1.1),
)

# Add a grid to the plot
plt.grid(True, linestyle="-", linewidth=0.5, axis="y")

# Set the background color of the plot
ax = plt.gca()
ax.set_facecolor(
    mcolors.LinearSegmentedColormap.from_list("custom", ["#d1e7e5", "#ffffff"])(0.8)
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_261.pdf", bbox_inches="tight")
