
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

years = np.arange(2000, 2011)
avg_temp_city1 = np.linspace(15, 17, 11) + np.random.normal(0, 0.3, 11)
avg_temp_city2 = np.linspace(16, 18, 11) + np.random.normal(0, 0.3, 11)
avg_precip_city1 = np.linspace(100, 110, 11) + np.random.normal(0, 5, 11)
avg_precip_city2 = np.linspace(105, 115, 11) + np.random.normal(0, 5, 11)

# Axes Limits and Labels
xlabel_value = "Year"
xticks_values = np.arange(2000, 2011, 1)

ylabel_value_temp = "Average Temperature (°C)"
ylim_values_temp = [10, 20]

ylabel_value_precip = "Average Precipitation (mm)"
ylim_values_precip = [80, 130]

# Labels
label_temp_city1 = "City 1 Temp"
label_temp_city2 = "City 2 Temp"
label_precip_city1 = "City 1 Precip"
label_precip_city2 = "City 2 Precip"

# Titles
title_temp = "Average Annual Temperature"
title_precip = "Average Annual Precipitation"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 5))

# Color variables
color_temp_city1 = "#1f77b4"
color_temp_city2 = "#ff7f0e"
color_precip_city1 = "#2ca02c"
color_precip_city2 = "#d62728"

# Plot the data in each subplot
ax1.plot(
    years,
    avg_temp_city1,
    marker="s",
    markersize=7,
    color=color_temp_city1,
    mfc="w",
    mew=2,
    label=label_temp_city1,
    linewidth=2,
    linestyle='-'
)
ax1.plot(
    years,
    avg_temp_city2,
    marker="D",
    markersize=7,
    color=color_temp_city2,
    mfc="w",
    mew=2,
    label=label_temp_city2,
    linewidth=2,
    linestyle='--'
)
ax1.set_title(title_temp, fontsize=10)
ax1.set_xlabel(xlabel_value, fontsize=10)
ax1.set_ylabel(ylabel_value_temp, fontsize=10)
ax1.set_ylim(ylim_values_temp)
ax1.set_xticks(xticks_values)
ax1.legend()
ax1.grid(True, linestyle="--", alpha=0.6)

ax2.plot(
    years,
    avg_precip_city1,
    marker="v",
    markersize=7,
    color=color_precip_city1,
    mfc="w",
    mew=2,
    label=label_precip_city1,
    linewidth=2,
    linestyle='-.'
)
ax2.plot(
    years,
    avg_precip_city2,
    marker="o",
    markersize=4,
    color=color_precip_city2,
    mfc="w",
    mew=2,
    label=label_precip_city2,
    linewidth=2,
    linestyle=':'
)
ax2.set_title(title_precip, fontsize=10)
ax2.set_xlabel(xlabel_value, fontsize=10)
ax2.set_ylabel(ylabel_value_precip, fontsize=10)
ax2.set_ylim(ylim_values_precip)
ax2.set_xticks(xticks_values)
ax2.legend()
ax2.grid(True, linestyle="--", alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_264.pdf", bbox_inches="tight")
