
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate data for four policies over 12 months
months = np.arange(1, 13)
policy1 = np.linspace(20, 70, 12) + np.random.normal(0, 5, 12)
policy2 = np.linspace(30, 80, 12) + np.random.normal(0, 5, 12)
policy3 = np.linspace(25, 75, 12) + np.random.normal(0, 5, 12)
policy4 = np.linspace(40, 90, 12) + np.random.normal(0, 5, 12)

# Axes Limits and Labels
xlabel_value = "Month"
xticks_values = np.arange(1, 13, 1)

ylabel_value = "Public Support (%)"
ylim_values = [0, 100]

# Labels
label_Policy1 = "Policy 1"
label_Policy2 = "Policy 2"
label_Policy3 = "Policy 3"
label_Policy4 = "Policy 4"

# Titles
title_1 = "Public Support Trends: Policy 1 vs Policy 2"
title_2 = "Public Support Trends: Policy 3 vs Policy 4"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(8, 3))

# Plot the data in each subplot
ax1.plot(
    months,
    policy1,
    marker="o",
    markersize=7,
    color="#1f77b4",
    mfc="w",
    mew=2,
    label=label_Policy1,
    linewidth=2,
)
ax1.plot(
    months,
    policy2,
    marker="s",
    markersize=7,
    color="#ff7f0e",
    mfc="w",
    mew=2,
    label=label_Policy2,
    linewidth=2,
)
ax1.set_title(title_1, fontsize=12)
ax1.set_xlabel(xlabel_value, fontsize=14)
ax1.set_ylabel(ylabel_value, fontsize=14)
ax1.set_ylim(ylim_values)
ax1.set_xticks(xticks_values)
ax1.legend()
ax1.grid(True, linestyle="--", alpha=0.6)

ax2.plot(
    months,
    policy3,
    marker="^",
    markersize=7,
    color="#2ca02c",
    mfc="w",
    mew=2,
    label=label_Policy3,
    linewidth=2,
)
ax2.plot(
    months,
    policy4,
    marker="v",
    markersize=7,
    color="#d62728",
    mfc="w",
    mew=2,
    label=label_Policy4,
    linewidth=2,
)
ax2.set_title(title_2, fontsize=12)
ax2.set_xlabel(xlabel_value, fontsize=14)
ax2.set_ylabel(ylabel_value, fontsize=14)
ax2.set_ylim(ylim_values)
ax2.set_xticks(xticks_values)
ax2.legend()
ax2.grid(True, linestyle="--", alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_265.pdf", bbox_inches="tight")
