
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.lines import Line2D

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for the plot
days = np.array([1, 2, 3, 4, 5, 6, 7, 8, 9, 10])
stock_prices = np.clip(
    np.linspace(100, 150, len(days)) + np.random.normal(0, 5, len(days)),
    90,
    None,
)
trading_volume = np.clip(
    np.linspace(2000, 2500, len(days)) + np.random.normal(0, 200, len(days)),
    1500,
    3000,
)
normal_price = [125] * len(days)  # Normal stock price baseline
safe_volume = [2250] * len(days)  # Safe trading volume baseline

# Axes Limits and Labels
xlabel_value = "Trading Days"
ylabel_value_1 = "Stock Price (USD)"
ylabel_value_2 = "Trading Volume (Shares)"
ylim_values_1 = [90, 160]
ylim_values_2 = [1500, 3000]
yticks_values_1 = range(90, 170, 10)
yticks_values_2 = range(1500, 3100, 500)

# Labels
label_1 = "Stock Price"
label_2 = "Trading Volume"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax1 = plt.subplots(figsize=(6, 5))

# Stock Price and Trading Volume plots
(temp_line,) = ax1.plot(
    days,
    stock_prices,
    "o-",
    color="#2ca02c",  # Green
    label=label_1,
    markersize=10,
    linewidth=3,
    mec="black",
)
ax1.set_xlabel(xlabel_value, fontsize=14)
ax1.set_ylabel(ylabel_value_1, fontsize=14, color="#2ca02c")
ax1.tick_params(
    axis="y", labelcolor="#2ca02c", direction="in", rotation=90, labelsize=12
)
ax1.tick_params(axis="x", direction="in", labelsize=12)
ax1.set_yticks(yticks_values_1)
ax1.set_ylim(ylim_values_1)

ax2 = ax1.twinx()
(co2_line,) = ax2.plot(
    days,
    trading_volume,
    "^-",
    color="#1f77b4",  # Blue
    label=label_2,
    markersize=10,
    linewidth=3,
    mec="black",
    linestyle="--"
)
ax2.set_ylabel(ylabel_value_2, color="#1f77b4", fontsize=14)
ax2.tick_params(
    axis="y", labelcolor="#1f77b4", direction="in", rotation=90, labelsize=12
)
ax2.set_yticks(yticks_values_2)
ax2.set_ylim(ylim_values_2)

# Normal stock price and safe trading volume baselines
ax1.axhline(y=125, color="#2ca02c", linestyle=":", linewidth=2)
ax1.axhline(y=2250, color="#1f77b4", linestyle="--", linewidth=2)

# Custom legend for the plot
normal_temp_legend = Line2D([0], [0], color="black", linestyle=":", linewidth=2, label="Normal Price")
safe_co2_legend = Line2D([0], [0], color="black", linestyle="--", linewidth=2, label="Safe Volume")

# Add the legend to the plot
first_legend = ax1.legend(
    handles=[normal_temp_legend, safe_co2_legend],
    loc="upper left",
    ncol=2,
    fontsize=14,
    edgecolor="black",
)
ax1.add_artist(first_legend)

# ===================
# Part 4: Saving Output
# ===================
# Add the second legend to the plot
plt.tight_layout()
plt.savefig("line_269.pdf", bbox_inches="tight")
