
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.lines import Line2D

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for the plot
internet_penetration_rate = np.array([10, 20, 30, 40, 50, 60, 70, 80, 90])
gdp_growth_rate = np.clip(
    np.linspace(1, 9, len(internet_penetration_rate)) + np.random.normal(0, 1, len(internet_penetration_rate)),
    1,
    None,
)
gdp_growth_rate_benchmark = [5] * len(internet_penetration_rate)

# Axes Limits and Labels
xlabel_value = "Internet Penetration Rate (%)"
ylabel_value_1 = "GDP Growth Rate (%)"
ylabel_value_2 = "GDP Growth Rate Benchmark (%)"
ylim_values_1 = [0, 15]
ylim_values_2 = [0, 15]
yticks_values_1 = range(0, 16, 3)
yticks_values_2 = range(0, 16, 3)

# Labels
label_1 = "GDP Growth Rate"
label_2 = "GDP Growth Rate Benchmark"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax1 = plt.subplots(figsize=(6, 5))

# Colors
color_green = "#2ca02c"
color_gold = "#ffdd44"
color_black = "black"

# GDP Growth Rate plot
(gdp_line,) = ax1.plot(
    internet_penetration_rate,
    gdp_growth_rate,
    "s-",
    color=color_green,
    label=label_1,
    markersize=10,
    linewidth=3,
    mec=color_black,
)
ax1.set_xlabel(xlabel_value, fontsize=14)
ax1.set_ylabel(ylabel_value_1, fontsize=14, color=color_green)
ax1.tick_params(
    axis="y", labelcolor=color_green, direction="in", rotation=90, labelsize=12
)
ax1.tick_params(axis="x", direction="in", labelsize=12)
ax1.set_yticks(yticks_values_1)
ax1.set_ylim(ylim_values_1)

ax2 = ax1.twinx()
(gdp_benchmark_line,) = ax2.plot(
    internet_penetration_rate,
    gdp_growth_rate_benchmark,
    "D-",
    color=color_gold,
    label=label_2,
    markersize=10,
    linewidth=3,
    mec=color_black,
)
ax2.set_ylabel(ylabel_value_2, color=color_gold, fontsize=14)
ax2.tick_params(
    axis="y", labelcolor=color_gold, direction="in", rotation=90, labelsize=12
)
ax2.set_yticks(yticks_values_2)
ax2.set_ylim(ylim_values_2)

# GDP Growth Rate benchmark line
ax1.axhline(y=5, color=color_gold, linestyle="--", linewidth=2)

# Custom legend for the plot
gdp_legend = Line2D([0], [0], color=color_black, linestyle="--", linewidth=2, label="GDP Benchmark")

# Add the legend to the plot
first_legend = ax1.legend(
    handles=[gdp_legend],
    loc="upper left",
    ncol=1,
    fontsize=14,
    edgecolor=color_black,
)
ax1.add_artist(first_legend)

# ===================
# Part 4: Saving Output
# ===================
# Add the second legend to the plot
plt.tight_layout()
plt.savefig("line_270.pdf", bbox_inches="tight")
