
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.lines import Line2D

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data for the plot
years = np.arange(2010, 2020)
stock_a_price = np.clip(
    np.linspace(50, 150, len(years)) + np.random.normal(0, 5, len(years)), 40, 160
)
stock_b_price = np.clip(
    np.linspace(60, 120, len(years)) + np.random.normal(0, 4, len(years)), 50, 130
)
stock_a_volume = np.clip(
    np.linspace(100, 50, len(years)) + np.random.normal(0, 5, len(years)), 40, 110
)
stock_b_volume = np.clip(
    np.linspace(90, 45, len(years)) + np.random.normal(0, 5, len(years)), 35, 100
)

# Axes Limits and Labels
xlabel_value = "Year"
ylabel_value_1 = "Stock Price ($)"
ylabel_value_2 = "Trading Volume (in Millions)"
ylim_values_1 = [30, 170]
ylim_values_2 = [30, 140]
yticks_values_1 = np.arange(30, 180, 20)
yticks_values_2 = np.arange(30, 150, 10)

# Labels
label_1 = "Stock A Price"
label_2 = "Stock B Price"
volume_label_1 = "Stock A Volume"
volume_label_2 = "Stock B Volume"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax1 = plt.subplots(figsize=(10, 8))

# Stock Prices plots
(stock_a_line,) = ax1.plot(
    years,
    stock_a_price,
    color="#1f77b4",
    label=label_1,
    markersize=8,
    linewidth=3,
    mec="black",
    linestyle="--",
    marker="D",
)
ax1.set_xlabel(xlabel_value, fontsize=14)
ax1.set_ylabel(ylabel_value_1, fontsize=14, color="#1f77b4")
ax1.tick_params(
    axis="y", labelcolor="#1f77b4", direction="in", labelsize=12
)
ax1.tick_params(axis="x", direction="in", labelsize=12)
ax1.set_yticks(yticks_values_1)
ax1.set_ylim(ylim_values_1)

# Create a secondary y-axis for Trading Volume of Stock A and Stock B
ax2 = ax1.twinx()
(stock_b_line,) = ax2.plot(
    years,
    stock_b_price,
    color="#ff7f0e",
    label=label_2,
    markersize=8,
    linewidth=3,
    mec="black",
    linestyle="-.",
    marker="o",
)
ax2.set_ylabel(ylabel_value_2, color="#ff7f0e", fontsize=14)
ax2.tick_params(
    axis="y", labelcolor="#ff7f0e", direction="in", labelsize=12
)
ax2.set_yticks(yticks_values_2)
ax2.set_ylim(ylim_values_2)

# Trading Volume trends
ax1.plot(years, stock_a_volume, ":", color="green", linewidth=2, label=volume_label_1)
ax1.plot(years, stock_b_volume, "--", color="#9467bd", linewidth=2, label=volume_label_2)

# Custom legend for the plot
volume_legend_1 = Line2D(
    [0], [0], color="green", linestyle=":", linewidth=2, label=volume_label_1
)
volume_legend_2 = Line2D(
    [0], [0], color="#9467bd", linestyle="--", linewidth=2, label=volume_label_2
)

# Add the legend to the plot
first_legend = ax1.legend(
    handles=[volume_legend_1, volume_legend_2],
    loc="upper left",
    ncol=2,
    fontsize=14,
    edgecolor="black",
)
ax1.add_artist(first_legend)  # Add the first legend back to the plot
second_legend = ax1.legend(
    handles=[stock_a_line, stock_b_line], loc="upper right", fontsize=14, edgecolor="black"
)  # Add the second legend

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()
plt.savefig("line_272.pdf", bbox_inches="tight")
