

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.lines import Line2D

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the plot
years = np.arange(2013, 2023)
netflix = np.clip(
    np.linspace(30, 45, len(years)) + np.random.normal(0, 2, len(years)),
    20,
    50,
)
amazon_prime = np.clip(
    np.linspace(20, 25, len(years)) + np.random.normal(0, 1.5, len(years)),
    15,
    30,
)
disney_plus = np.clip(
    np.linspace(0, 20, len(years)) + np.random.normal(0, 2, len(years)),
    0,
    25,
)
hulu = np.clip(
    np.linspace(10, 15, len(years)) + np.random.normal(0, 1, len(years)),
    5,
    20,
)

# Axes Limits and Labels
xlabel_value = "Years"
ylabel_value_1 = "Percentage of Market Share (%)"
ylabel_value_2 = "Percentage of Market Share (%)"
ylim_values_1 = [0, 60]
ylim_values_2 = [0, 30]
yticks_values_1 = np.arange(0, 70, 10)
yticks_values_2 = np.arange(0, 35, 5)

# Labels
label_1 = "Netflix"
label_2 = "Amazon Prime"
label_3 = "Disney+"
label_4 = "Hulu"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
color_1 = "#1f78b4"
color_2 = "#33a02c"
color_3 = "#ff7f00"
color_4 = "#6a3d9a"

# Create a figure and axis
fig, ax1 = plt.subplots(figsize=(10, 8))

# Netflix and Amazon Prime plots
(netflix_line,) = ax1.plot(
    years,
    netflix,
    color=color_1,
    label=label_1,
    markersize=8,
    linewidth=2,
    mec="black",
    linestyle="-",
    marker="o",
)
ax1.set_xlabel(xlabel_value, fontsize=14)
ax1.set_ylabel(ylabel_value_1, fontsize=14, color=color_1)
ax1.tick_params(
    axis="y", labelcolor=color_1, direction="in", labelsize=12
)
ax1.tick_params(axis="x", direction="in", labelsize=12)
ax1.set_yticks(yticks_values_1)
ax1.set_ylim(ylim_values_1)

# Create a secondary y-axis for Amazon Prime
ax2 = ax1.twinx()
(amazon_prime_line,) = ax2.plot(
    years,
    amazon_prime,
    color=color_2,
    label=label_2,
    markersize=8,
    linewidth=2,
    mec="black",
    linestyle="--",
    marker="s",
)
ax2.set_ylabel(ylabel_value_2, color=color_2, fontsize=14)
ax2.tick_params(
    axis="y", labelcolor=color_2, direction="in", labelsize=12
)
ax2.set_yticks(yticks_values_2)
ax2.set_ylim(ylim_values_2)

# Disney+ and Hulu
ax1.plot(
    years, 
    disney_plus, 
    color=color_3, 
    linewidth=2, 
    linestyle=":", 
    marker="^", 
    markersize=8, 
    label=label_3
)
ax1.plot(
    years, 
    hulu, 
    color=color_4, 
    linewidth=2, 
    linestyle="-.", 
    marker="*", 
    markersize=8, 
    label=label_4
)

# Custom legend for the plot
netflix_legend = Line2D(
    [0], [0], color=color_1, linestyle="-", linewidth=2, marker="o", markersize=8, label=label_1
)
amazon_prime_legend = Line2D(
    [0], [0], color=color_2, linestyle="--", linewidth=2, marker="s", markersize=8, label=label_2
)
disney_plus_legend = Line2D(
    [0], [0], color=color_3, linestyle=":", linewidth=2, marker="^", markersize=8, label=label_3
)
hulu_legend = Line2D(
    [0], [0], color=color_4, linestyle="-.", linewidth=2, marker="*", markersize=8, label=label_4
)

# Add the legend to the plot
first_legend = ax1.legend(
    handles=[netflix_legend, amazon_prime_legend], loc="upper left", fontsize=12, edgecolor="black"
)
ax1.add_artist(first_legend)  # Add the first legend back to the plot
second_legend = ax1.legend(
    handles=[disney_plus_legend, hulu_legend], loc="upper right", fontsize=12, edgecolor="black"
)  # Add the second legend

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()
plt.savefig("line_273.pdf", bbox_inches="tight")

