
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for the plot
import numpy as np

np.random.seed(0)
days = np.arange(1, 31)
temperature_day = np.clip(
    np.linspace(15, 35, len(days)) + np.random.normal(0, 3, len(days)),
    15,
    35,
)
temperature_night = np.clip(
    np.linspace(5, 25, len(days)) + np.random.normal(0, 3, len(days)),
    5,
    25,
)

# Axes Limits and Labels
xlabel_value = "Days of the Month"

ylabel_value_1 = "Day Temperature (°C)"
ylabel_value_2 = "Night Temperature (°C)"

# Labels
label_1 = "Day Temperature"
label_2 = "Night Temperature"

# Threshold Label
label = "Temperature Threshold"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

(day_temp_line,) = ax.plot(
    days,
    temperature_day,
    "o-",
    color="#1a9641",
    label=label_1,
    markersize=8,
    linewidth=2,
)
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value_1, fontsize=12)
ax.tick_params(axis="y", direction="in", labelsize=10)
ax.tick_params(axis="x", direction="in", labelsize=10)

# Create a secondary y-axis for Night Temperature
(night_temp_line,) = ax.plot(
    days,
    temperature_night,
    "s--",
    color="#3288bd",
    label=label_2,
    markersize=8,
    linewidth=2,
)

# Add a legend to the plot
threshold = 30
ax.axhline(y=threshold, color="red", linestyle="-", linewidth=1.5, label=label)

# Highlight the data points above the threshold
highlight = [15, 25]  # Days to highlight
for day in highlight:
    ax.plot(
        day, temperature_day[np.where(days == day)], "ro"
    )  # Highlight Day Temperature
    ax.annotate(
        f"Highlight {day}",
        (day, temperature_day[np.where(days == day)]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
    )

# Customize the plot with labels, title, and legend
ax.legend()

# Add a grid to the plot
ax.grid(True, linestyle="--", alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()
plt.savefig("line_275.pdf", bbox_inches="tight")
