
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for the plot
time_points = np.array([1, 2, 3, 4, 5, 6, 7])
region_a_sales = np.clip(
    np.sin(np.linspace(0, 2 * np.pi, len(time_points))) * 50 + 100 + np.random.normal(0, 10, len(time_points)),
    60,
    150,
)
region_b_sales = np.clip(
    np.cos(np.linspace(0, 3 * np.pi, len(time_points))) * 40 + 120 + np.random.normal(0, 15, len(time_points)),
    70,
    160,
)
region_c_sales = np.clip(
    np.sin(np.linspace(0, 4 * np.pi, len(time_points))) * 30 + 110 + np.random.normal(0, 20, len(time_points)),
    50,
    140,
)
highlight = [3, 5, 6]

# Axes Limits and Labels
xlabel_value = "Time Points"
ylabel_value_1 = "Region A Sales ($K)"
ylabel_value_2 = "Region B Sales ($K)"
ylabel_value_3 = "Region C Sales ($K)"

# Labels
label_1 = "Region A"
label_2 = "Threshold"
label_3 = "Region B"
label_4 = "Region C"

# Additional Parameters
highlight_annotation = "Above Threshold"
supertitle_value = "Sales Performance Over Time By Region"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with a 1x3 grid
fig, axs = plt.subplots(1, 3, figsize=(18, 6), sharey=True)

# Colors
color_1 = "#1f78b4"  # Blue
color_2 = "#33a02c"  # Green
color_3 = "#e31a1c"  # Red
threshold_color = "#ff7f00"  # Orange

# Plot the Region A data
axs[0].plot(
    time_points,
    region_a_sales,
    "o-",
    color=color_1,
    label=label_1,
    markersize=8,
    linewidth=2,
)
axs[0].set_xlabel(xlabel_value, fontsize=12)
axs[0].set_ylabel(ylabel_value_1, fontsize=12)
axs[0].tick_params(axis="y", direction="in", labelsize=10)
axs[0].tick_params(axis="x", direction="in", labelsize=10)

# Plot the Region B data
axs[1].plot(
    time_points,
    region_b_sales,
    "s--",
    color=color_2,
    label=label_3,
    markersize=8,
    linewidth=2,
)
axs[1].set_xlabel(xlabel_value, fontsize=12)

# Plot the Region C data
axs[2].plot(
    time_points,
    region_c_sales,
    "d-.",
    color=color_3,
    label=label_4,
    markersize=8,
    linewidth=2,
)
axs[2].set_xlabel(xlabel_value, fontsize=12)

# Add a threshold line to all plots
threshold = 110
for ax in axs:
    ax.axhline(y=threshold, color=threshold_color, linestyle="-", linewidth=1.5, label=label_2)

# Highlight the data points above the threshold
for ax in axs:
    for tp in highlight:
        y_vals = []
        if ax == axs[0]:
            y_vals = region_a_sales
        elif ax == axs[1]:
            y_vals = region_b_sales
        else:
            y_vals = region_c_sales
        
        ax.plot(
            tp, y_vals[np.where(time_points == tp)], "ro"
        )  # Highlight data points
        ax.annotate(
            highlight_annotation,
            (tp, y_vals[np.where(time_points == tp)]),
            textcoords="offset points",
            xytext=(0, -20),
            ha="center",
        )

# Customize legends and grid
for ax in axs:
    ax.legend()
    ax.grid(True, linestyle="--", alpha=0.6)

# Super Title for the figure
fig.suptitle(supertitle_value, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("line_279.pdf", bbox_inches="tight")
