
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for average monthly temperatures (in degrees Celsius)
months = np.arange(1, 13)  # Representing months from January to December
station_a = [2, 4, 9, 15, 20, 25, 28, 27, 22, 16, 9, 3]
station_b = [-5, -3, 2, 10, 15, 22, 25, 23, 18, 10, 3, -2]
station_c = [0, 1, 5, 12, 18, 24, 27, 26, 21, 13, 6, 1]
station_d = [8, 9, 12, 18, 23, 29, 32, 31, 26, 20, 14, 9]

# Labels and Plot Types
label_station_a = "Weather Station A"
label_station_b = "Weather Station B"
label_station_c = "Weather Station C"
label_station_d = "Weather Station D"
xlabel_value = "Months"
ylabel_value = "Average Temperature (°C)"

# Axes Limits and Labels
xlim_values = [1, 12]
ylim_values = [-10, 40]
xticks_values = np.arange(1, 13, 1)
yticks_values = np.arange(-10, 41, 10)
title = "Average Monthly Temperature Trends Across Different Weather Stations"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
plt.figure(figsize=(10, 6))  # Adjusting figure size for better readability

plt.plot(
    months,
    station_a,
    "-D",
    label=label_station_a,
    color="#2E8B57",  # Sea Green
    clip_on=False,
    zorder=10,
    linewidth=2,
    markersize=8,
)

plt.plot(
    months,
    station_b,
    "-v",
    label=label_station_b,
    color="#4682B4",  # Steel Blue
    clip_on=False,
    zorder=10,
    linewidth=2,
    markersize=8,
)

plt.plot(
    months,
    station_c,
    "-s",
    label=label_station_c,
    color="#8B4513",  # Saddle Brown
    clip_on=False,
    zorder=10,
    linewidth=2,
    markersize=8,
)

plt.plot(
    months,
    station_d,
    "-o",
    label=label_station_d,
    color="#32CD32",  # Lime Green
    clip_on=False,
    zorder=10,
    linewidth=2,
    markersize=8,
)

# Set y-axis to only display specific ticks and extend y-axis to leave space at the top
plt.yticks(yticks_values)
plt.ylim(ylim_values)  # Adjusted y-axis limit
plt.xticks(xticks_values)
plt.xlim(xlim_values)

# Adding grid, legend, and labels
plt.grid(True, linestyle='--', alpha=0.7)
plt.legend(loc="upper left", bbox_to_anchor=(1.05, 1), ncol=1, frameon=False)
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.title(title, pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_72.pdf", bbox_inches="tight")
