
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
years = [2000, 2005, 2010, 2015, 2020]  # Years from 2000 to 2020
period1_values = [50, 55, 60, 65, 70]  # Movie attendance in millions for period 1
period2_values = [40, 45, 50, 55, 60]  # Movie attendance in millions for period 2
period3_values = [30, 35, 40, 45, 50]  # Movie attendance in millions for period 3

# Simulating standard deviations for error
period1_std = np.random.rand(5) * 5
period2_std = np.random.rand(5) * 5
period3_std = np.random.rand(5) * 5

# Labels
label_Period_1 = "Period 1"
label_Period_2 = "Period 2"
label_Period_3 = "Period 3"

# Axes Labels and Ticks
xlabel_value = "Years"
ylabel_value = "Movie Attendance (in millions)"
yticks_values = np.arange(20, 81, 10)
title_label = "Movie Attendance Trends Over Years"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the lines with error bands
plt.figure(figsize=(6, 4))
plt.plot(years, period1_values, "o-", color="#8B4513", label=label_Period_1, linestyle='-', linewidth=2, markersize=6)
plt.fill_between(
    years,
    np.array(period1_values) - period1_std,
    np.array(period1_values) + period1_std,
    color="#8B4513",
    alpha=0.2,
)

plt.plot(years, period2_values, "s-", color="#2E8B57", label=label_Period_2, linestyle='--', linewidth=2, markersize=6)
plt.fill_between(
    years,
    np.array(period2_values) - period2_std,
    np.array(period2_values) + period2_std,
    color="#2E8B57",
    alpha=0.2,
)

plt.plot(years, period3_values, "^-", color="#4682B4", label=label_Period_3, linestyle='-.', linewidth=2, markersize=6)
plt.fill_between(
    years,
    np.array(period3_values) - period3_std,
    np.array(period3_values) + period3_std,
    color="#4682B4",
    alpha=0.2,
)

# x and y labels
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)
plt.xticks(years)
plt.yticks(yticks_values)
plt.title(title_label, fontsize=14)

# Moving axes spines
ax = plt.gca()  # get current axes
ax.spines["left"].set_position(("outward", 10))  # move left y-axis outwards
ax.spines["bottom"].set_position(("outward", 10))  # move bottom x-axis outwards
ax.spines["right"].set_color("none")  # hide the right spine
ax.spines["top"].set_color("none")  # hide the top spine
ax.grid(
    True, which="both", axis="both", color="lightgray", linestyle="--", linewidth=0.5
)

# Add legend
plt.legend(loc="upper left", fontsize=10)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig("line_74.pdf", bbox_inches="tight")
