
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for politics domain
np.random.seed(1)
years = [2018, 2019, 2020, 2021, 2022]  # 5 Year Period

# Average approval ratings for three political figures
politician_A_ratings = [55, 60, 62, 59, 61]
politician_B_ratings = [50, 52, 53, 51, 50]
politician_C_ratings = [65, 63, 67, 66, 68]

# Simulating standard deviations for error
politician_A_std = np.random.rand(5) * 5
politician_B_std = np.random.rand(5) * 5
politician_C_std = np.random.rand(5) * 5

# Labels
label_Politician_A = "Politician A"
label_Politician_B = "Politician B"
label_Politician_C = "Politician C"

# Axes Limits and Labels
xlabel_value = "Year"
ylabel_value = "Average Approval Rating"
yticks_values = np.arange(40, 81, 5)

# Title and Supertitle
title_value = "Average Approval Ratings by Year"
supertitle_value = "Political Approval Trends"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the lines with error bands
plt.figure(figsize=(6, 4))
color_A = "dodgerblue"
color_B = "darkorange"
color_C = "forestgreen"

plt.plot(years, politician_A_ratings, "s-", color=color_A, label=label_Politician_A, linewidth=1.5)
plt.fill_between(
    years,
    np.array(politician_A_ratings) - politician_A_std,
    np.array(politician_A_ratings) + politician_A_std,
    color=color_A,
    alpha=0.2,
)

plt.plot(years, politician_B_ratings, "^-", color=color_B, label=label_Politician_B, linewidth=1.5)
plt.fill_between(
    years,
    np.array(politician_B_ratings) - politician_B_std,
    np.array(politician_B_ratings) + politician_B_std,
    color=color_B,
    alpha=0.2,
)

plt.plot(years, politician_C_ratings, "o-", color=color_C, label=label_Politician_C, linewidth=1.5)
plt.fill_between(
    years,
    np.array(politician_C_ratings) - politician_C_std,
    np.array(politician_C_ratings) + politician_C_std,
    color=color_C,
    alpha=0.2,
)

# Labels and title
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)
plt.xticks(years)
plt.yticks(yticks_values)
plt.title(title_value, fontsize=14)
plt.suptitle(supertitle_value, fontsize=16)

# Moving axes spines
ax = plt.gca()  # get current axes
ax.spines["left"].set_position(("outward", 10))  # move left y-axis outwards
ax.spines["bottom"].set_position(("outward", 10))  # move bottom x-axis outwards
ax.spines["right"].set_color("none")  # hide the right spine
ax.spines["top"].set_color("none")  # hide the top spine
ax.grid(
    True, which="both", axis="both", color="lightgray", linestyle="--", linewidth=0.5
)

# Legend
plt.legend(loc="upper left", fontsize=10)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig("line_75.pdf", bbox_inches="tight")

