
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for Internet Usage Rates
years = np.array(["2015", "2016", "2017", "2018", "2019", "2020", "2021", "2022"])
urban_usage = np.array([50, 55, 60, 65, 70, 75, 80, 85])
urban_err = np.array([3, 4, 3, 2, 3, 4, 2, 3])

rural_usage = np.array([15, 20, 25, 30, 35, 40, 50, 55])
rural_err = np.array([4, 3, 4, 3, 2, 3, 4, 3])

# Labels
label_urban = "Urban Internet Usage"
label_rural = "Rural Internet Usage"
title = "Internet Usage Rates Over Time"
xlabel_value = "Year"
ylabel_value = "Usage Rate (%)"
legend_location = "upper left"

# Axes Limits and Labels
yticks_values = np.arange(0, 101, 20)
ylim_values = [0, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 6))

plt.errorbar(
    years,
    urban_usage,
    yerr=urban_err,
    fmt="o-",
    label=label_urban,
    color="#1f77b4",
    capsize=5,
    linewidth=2,
    markersize=8
)
plt.errorbar(
    years,
    rural_usage,
    yerr=rural_err,
    fmt="--",
    label=label_rural,
    color="#2ca02c",
    marker="s",
    capsize=5,
    linewidth=2,
    markersize=8
)

# Set x,y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, fontsize=14)
plt.ylim(ylim_values)

# Set x-axis label to be rotated and styled
plt.xticks(rotation=45, fontsize=12)

# Adding labels and title
plt.title(title, fontsize=18)
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)
plt.legend(loc=legend_location, fontsize=14)

# Adjusting figure size
plt.gcf().set_size_inches(10, 6)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_77.pdf", bbox_inches="tight")
