
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for quarterly average temperature (in Celsius)
temperature_x = np.array([
    "Q1 2022", "Q2 2022", "Q3 2022", "Q4 2022", 
    "Q1 2023", "Q2 2023", "Q3 2023", "Q4 2023"
])
temperature_y = np.array([5, 15, 20, 10, 6, 16, 21, 11])
temperature_err = np.array([1, 2, 2, 1, 1, 2, 2, 1])

# Data for quarterly average precipitation (in mm)
precipitation_x = np.array([
    "Q1 2022", "Q2 2022", "Q3 2022", "Q4 2022", 
    "Q1 2023", "Q2 2023", "Q3 2023", "Q4 2023"
])
precipitation_y = np.array([80, 60, 40, 70, 85, 65, 45, 75])
precipitation_err = np.array([5, 10, 8, 6, 5, 10, 8, 6])

# Labels for the chart
label_temperature = "Average Temperature"
label_precipitation = "Average Precipitation"
xlabel_value = "Quarters"
ylabel_value = "Values"

# Axes Limits and Labels
yticks_values = np.arange(0, 101, 10)
ylim_values = [0, 100]

title = "Quarterly Weather Data"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(
    figsize=(10, 5)
)

plt.errorbar(
    temperature_x,
    temperature_y,
    yerr=temperature_err,
    fmt="o-",
    label=label_temperature,
    color="#2c7bb6",  # Deep blue
    capsize=5,
)

plt.errorbar(
    precipitation_x,
    precipitation_y,
    yerr=precipitation_err,
    fmt="--",
    label=label_precipitation,
    color="#d7191c",  # Deep red
    marker="s",
    capsize=5,
)

# Set x,y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, fontsize=16)
plt.ylim(ylim_values)

# set x-axis label to be rotated
plt.xticks(rotation=45, fontsize=12)

# Adding labels and title
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)
plt.title(title, fontsize=18)
plt.legend(loc="upper left", fontsize=16)

# Adjusting figure size to match the original image's dimensions
plt.gcf().set_size_inches(10, 5)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_78.pdf", bbox_inches="tight")
