
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for 2022 new legal cases (in thousands)
categories = np.array(["Family Law", "Criminal Law", "Corporate Law", "Civil Rights", "Environmental Law", "Intellectual Property"])
cases_2022 = np.array([150, 300, 200, 180, 160, 220])
err_2022 = np.array([10, 15, 12, 9, 10, 11])

# Data for 2023 new legal cases (in thousands)
cases_2023 = np.array([160, 310, 210, 190, 170, 230])
err_2023 = np.array([11, 16, 13, 10, 11, 12])

# Labels
label_2022 = "New Cases 2022"
label_2023 = "New Cases 2023"

# Axes Limits and Labels
ylabel_value = "New Cases Filed (in thousands)"
xlabel_value = "Legal Categories"
title_value = "New Legal Cases by Category (2022 vs 2023)"
yticks_values = np.arange(140, 331, 20)
ylim_values = [140, 335]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(12, 6))  # Adjusting figure size

plt.errorbar(
    categories,
    cases_2022,
    yerr=err_2022,
    fmt="o-",
    label=label_2022,
    color="#1f77b4",  # Modern color for 2022 cases
    capsize=5,
    linewidth=2,
    markersize=8,
)

plt.errorbar(
    categories,
    cases_2023,
    yerr=err_2023,
    fmt="s--",
    label=label_2023,
    color="#ff7f0e",  # Modern color for 2023 cases
    capsize=5,
    linewidth=2,
    markersize=8,
)

# Set x, y-axis to display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, fontsize=14)
plt.ylim(ylim_values)
plt.xticks(rotation=45, fontsize=14)

# Adding labels and title
plt.ylabel(ylabel_value, fontsize=16)
plt.xlabel(xlabel_value, fontsize=16)
plt.title(title_value, fontsize=18)
plt.legend(loc="upper left", fontsize=14)

# Adjusting layout to reduce white space
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("line_79.pdf", bbox_inches="tight")
