

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for plotting
age_groups = ["10-20", "21-30", "31-40", "41-50"]  # Update for categorical x-axis
vehicle_ownership = [30, 50, 60, 70]
public_transport_usage = [70, 50, 40, 30]
vehicle_ownership_post_policy = [25, 45, 55, 65]
public_transport_usage_post_policy = [75, 55, 45, 35]

# Axes Limits and Labels
xticks_values = range(len(age_groups))
ylabel_value = "Percentage (%)"
xlabel_value = "Age Groups"

# Labels
label_1 = "Vehicle Ownership"
label_2 = "Public Transport Usage"
label_3 = "Post Policy Vehicle Ownership"
label_4 = "Post Policy Public Transport Usage"

# Titles
title_1 = "Vehicle Ownership Levels"
title_2 = "Public Transport Usage Levels"
supertitle = "Transportation Trends Across Age Groups"

# Texts
text_1 = "Decrease -5%"
text_2 = "Increase +5%"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 5))

# Plotting for Vehicle Ownership Levels
color_1 = "#1f77b4"
ax1.set_xticks(xticks_values)  # Setting categorical x-axis
ax1.plot(
    age_groups,
    vehicle_ownership,
    marker="o",
    color=color_1,
    label=label_1,
    linewidth=4,
    markersize=8,
)
ax1.plot(
    age_groups,
    vehicle_ownership_post_policy,
    marker="o",
    linestyle="--",
    color=color_1,
    label=label_3,
    linewidth=4,
    markersize=8,
)
ax1.set_title(title_1, fontsize=16)
ax1.set_ylabel(ylabel_value, fontsize=16)  # Adjusted font size
ax1.legend(loc="lower right", fontsize=14)
ax1.set_xticklabels(age_groups, fontsize=12)  # Adjust font size for x-axis labels
ax1.grid(True, which="both", ls="--", color="grey", linewidth=1, axis="y", alpha=0.5)
ax1.annotate(
    "",
    xy=(0, vehicle_ownership[0]),
    xytext=(0, vehicle_ownership_post_policy[0]),
    arrowprops=dict(color="green", shrink=0.05, width=1.5, headwidth=8),
    annotation_clip=False,
)
ax1.text(
    0.1,
    (vehicle_ownership[0] + vehicle_ownership_post_policy[0]) / 2,
    text_1,
    ha="left",
    va="center",
    fontsize=14,
    color="black",
)

# Plotting for Public Transport Usage Levels
color_2 = "#ff7f0e"
ax2.plot(
    age_groups,
    public_transport_usage,
    marker="o",
    color=color_2,
    label=label_2,
    linewidth=4,
    markersize=8,
)
ax2.plot(
    age_groups,
    public_transport_usage_post_policy,
    marker="o",
    linestyle="--",
    color=color_2,
    label=label_4,
    linewidth=4,
    markersize=8,
)
ax2.set_title(title_2, fontsize=16)  # Adjusted font size
ax2.legend(loc="upper left", fontsize=14)
ax2.set_xticklabels(age_groups, fontsize=12)  # Ensure x-axis labels are set for both axes
ax2.grid(True, which="both", ls="--", color="grey", linewidth=1, axis="y", alpha=0.5)
ax2.annotate(
    "",
    xy=(0, public_transport_usage[0]),
    xytext=(0, public_transport_usage_post_policy[0]),
    arrowprops=dict(color="red", shrink=0.05, width=1.5, headwidth=8),
    annotation_clip=False,
)
ax2.text(
    0.1,
    (public_transport_usage[0] + public_transport_usage_post_policy[0]) / 2,
    text_2,
    ha="left",
    va="center",
    fontsize=14,
    color="black",
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and add common annotation for resolution
plt.suptitle(supertitle, fontsize=18, weight='bold')
plt.tight_layout(rect=[0, 0, 1, 0.96])
plt.savefig("line_81.pdf", bbox_inches="tight")

