

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Seed for reproducibility
np.random.seed(0)

# Data for plotting
time_periods = ["Q1", "Q2", "Q3", "Q4"]  # Categorical x-axis
doctor_visits = [3, 4, 2, 1]  # Number of doctor visits per period
medications_taken = [1, 2, 3, 2]  # Number of medications taken per period
preventive_measures = [2, 3, 4, 5]  # Number of preventive measures taken per period
weight_loss = [1.5, 2.0, 2.5, 3.0]  # Weight loss in kg over periods

# Axes Limits and Labels
xticks_values = range(len(time_periods))
ylabel_value = "Health Metrics"
xlabel_value = "Time Periods"

# Labels
label_1 = "Doctor Visits"
label_2 = "Preventive Measures"

# Titles
title_1 = "Doctor Visits and Medications Taken"
title_2 = "Preventive Measures and Weight Loss"

# Texts
text_1 = "Visits: 3"
text_2 = "Measures: 2"

labels = ["Medications Taken", "Weight Loss (kg)"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 5))

# Color Configuration
color_doctor_visits = "#1f77b4"
color_medications_taken = "#ff7f0e"
color_preventive_measures = "#2ca02c"
color_weight_loss = "#d62728"
color_grid = "grey"
color_annotation = "green"

# Plotting for Doctor Visits and Medications Taken
ax1.set_xticks(xticks_values)  # Setting categorical x-axis
ax1.plot(
    time_periods,
    doctor_visits,
    marker="s",
    color=color_doctor_visits,
    label=label_1,
    linewidth=2,
    markersize=6,
)
ax1.plot(
    time_periods,
    medications_taken,
    marker="^",
    linestyle="--",
    color=color_medications_taken,
    label=labels[0],
    linewidth=2,
    markersize=6,
)
ax1.set_title(title_1, fontsize=16)
ax1.set_ylabel(ylabel_value, fontsize=14)  
ax1.legend(loc="best", fontsize=12)
ax1.set_xticklabels(time_periods, fontsize=12)  
ax1.grid(True, which="both", ls="--", color=color_grid, linewidth=1, axis="y", alpha=0.5)
ax1.annotate(
    "",
    xy=(0, medications_taken[0]),
    xytext=(0, doctor_visits[0]),
    arrowprops=dict(color=color_annotation, shrink=0.05, width=1.5, headwidth=8),
    annotation_clip=False,
)
ax1.text(
    0.1,
    (doctor_visits[0] + medications_taken[0]) / 2,
    text_1,
    ha="left",
    va="center",
    fontsize=12,
    color="black",
)

# Plotting for Preventive Measures and Weight Loss
ax2.plot(
    time_periods,
    preventive_measures,
    marker="s",
    color=color_preventive_measures,
    label=label_2,
    linewidth=2,
    markersize=6,
)
ax2.plot(
    time_periods,
    weight_loss,
    marker="^",
    linestyle="--",
    color=color_weight_loss,
    label=labels[1],
    linewidth=2,
    markersize=6,
)
ax2.set_title(title_2, fontsize=16)  
ax2.legend(loc="best", fontsize=12)
ax2.set_xticklabels(time_periods, fontsize=12)  
ax2.grid(True, which="both", ls="--", color=color_grid, linewidth=1, axis="y", alpha=0.5)
ax2.annotate(
    "",
    xy=(0, weight_loss[0]),
    xytext=(0, preventive_measures[0]),
    arrowprops=dict(color=color_annotation, shrink=0.05, width=1.5, headwidth=8),
    annotation_clip=False,
)
ax2.text(
    0.1,
    (preventive_measures[0] + weight_loss[0]) / 2,
    text_2,
    ha="left",
    va="center",
    fontsize=12,
    color="black",
)

# Common x-axis label
fig.text(0.5, 0.04, xlabel_value, ha='center', fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and add common annotation for resolution
plt.tight_layout()
plt.savefig("line_82.pdf", bbox_inches="tight")

