
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for plotting
years = np.array([2015, 2016, 2017, 2018, 2019, 2020])
source_A = np.array([1e2, 3e2, 5e2, 8e2, 1e3, 1.3e3])
source_B = np.array([1.5e2, 2e2, 4e2, 6e2, 1e3, 1.5e3])

# Axes Limits and Labels
xlabel_value = "Years"
ylabel_value = "Energy Consumption (GWh)"

ylim_values = [1e2, 2e3]
yticks_values = [10**2, 10**3, 10**4]
yticks_labels = ["$10^{2}$", "$10^{3}$", "$10^{4}$"]

# Labels
label_Source_A = "Renewable Energy"
label_Source_B = "Non-Renewable Energy"

# Title
title_value = "Energy Consumption Over Years by Different Sources"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(10, 6))

# Plot the data
plt.loglog(
    years,
    source_A,
    "o-",
    color="#2ca02c",
    label=label_Source_A,
    markerfacecolor="#2ca02c",
    markersize=6,
    linestyle='--'
)  # Dashed line for Source A
plt.loglog(
    years, 
    source_B, 
    "x-", 
    color="#d62728", 
    label=label_Source_B, 
    markersize=6,
    linestyle='-'
)  # Solid line for Source B

# Add labels with increased font size
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.title(title_value, fontsize=16)

# Set y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(
    yticks_values,
    yticks_labels,
)
plt.ylim(ylim_values)  # Extend y-axis to leave some space above 10^3

# Explicitly set the tick params for the x-axis
plt.tick_params(axis="x", labelsize=14)  # Ensure x-axis tick labels are of font size 14

# Add legend with transparent background
plt.legend(frameon=True, fontsize=12)

# Add a vertical line at x=2015 and enable horizontal grid lines for structure
plt.axvline(x=2015, color="grey", linestyle="--", linewidth=1)
plt.grid(
    True, which="both", ls="--", color="grey", linewidth=1, axis="y"
)  # Horizontal grid lines

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and display the plot
plt.tight_layout()
plt.savefig("line_86.pdf", bbox_inches="tight")
