

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for plotting
weeks = np.array([1, 2, 4, 8, 12, 16])
study_method_a = np.array([70, 75, 78, 80, 85, 88])
study_method_b = np.array([65, 70, 72, 75, 78, 82])

# Axes Limits and Labels
xlabel_value = "Time (Weeks)"
ylabel_value = "Average Grade"

# Update y-axis limits and ticks for grades
ylim_values = [60, 90]
yticks_values = [60, 65, 70, 75, 80, 85, 90]
yticks_labels = ["60%", "65%", "70%", "75%", "80%", "85%", "90%"]

# Labels
label_MethodA = "Study Method A"
label_MethodB = "Study Method B"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(9, 6))

# Plot the data
plt.semilogx(
    weeks,
    study_method_a,
    "o-",
    color="#2ca02c",  # Green color
    label=label_MethodA,
    markerfacecolor="#2ca02c",
    markersize=6,
    linewidth=2,
)  
plt.semilogx(
    weeks,
    study_method_b,
    "s--",
    color="#d62728",  # Red color
    label=label_MethodB,
    markerfacecolor="#d62728",
    markersize=6,
    linewidth=2,
)

# Add labels with increased font size
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)

# Set y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(
    yticks_values,
    yticks_labels,
)
plt.ylim(ylim_values) 

# Explicitly set the tick params for the x-axis
plt.tick_params(axis="x", labelsize=14)

# Add legend with transparent background
plt.legend(frameon=True, fontsize=14)

# Add a vertical line at x=1 and enable horizontal grid lines for structure
plt.axvline(x=1, color="grey", linestyle="--", linewidth=1)
plt.grid(
    True, which="both", ls="--", color="grey", linewidth=1, axis="both"
)  # Grid lines on both x and y axis

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and display the plot
plt.tight_layout()
plt.savefig("line_87.pdf", bbox_inches="tight")
