
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.ticker import FuncFormatter, FixedLocator

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data for plotting
months = np.array([1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12])
theater_a = np.random.randint(5000, 25000, size=12)
theater_b = np.random.randint(7000, 22000, size=12)

# Axes Limits and Labels
xlabel_value = "Months"
ylabel_value = "Monthly Ticket Sales"

yticks_values = [5000, 10000, 15000, 20000, 25000, 30000]
yticks_labels = [str(val) for val in yticks_values]
ylim_values = [0, 30000]

axvline_x = 6

# Labels
label_TheaterA = "Theater A"
label_TheaterB = "Theater B"

title_value = "Monthly Ticket Sales Trend"
suptitle_value = "Movie Theater Performance Analysis"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 6))
plt.plot(
    months,
    theater_a,
    "o-",
    label=label_TheaterA,
    color="#0d6efd",  # Blue
    linewidth=1.4,
    markersize=6,
)
plt.plot(
    months,
    theater_b,
    "s-",
    label=label_TheaterB,
    color="#198754",  # Green
    markersize=6,
    markeredgewidth=1,
    linestyle="--"
)

# Set y-axis to specific ticks
plt.yticks(
    yticks_values,
    yticks_labels,
)
plt.ylim(ylim_values)  # Extend y-axis to leave some space

# Enable grid for both x-axis and y-axis
plt.grid(True, which="both", ls="--", color='gray', alpha=0.7)

# Manually add a vertical line for month 6
plt.axvline(x=axvline_x, color="grey", linestyle="--", linewidth=0.8)

# Formatting the x-axis and y-axis tick labels
plt.gca().xaxis.set_major_locator(FixedLocator(months))
plt.gca().xaxis.set_major_formatter(FuncFormatter(lambda value, _: f"Month {int(value)}"))

# Adding labels, title, and supertitle
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)
plt.title(title_value, fontsize=14, pad=20)
plt.suptitle(suptitle_value, fontsize=16)

# Adding a legend at the upper right
plt.legend(loc="upper right", fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("line_96.pdf", bbox_inches="tight")
