

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify
from matplotlib.gridspec import GridSpec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Treemap data for artwork distribution by style
sizes_treemap = [60, 25, 15, 10, 5, 3]
labels_treemap = [
    "Abstract\n60%",
    "Impressionism\n25%",
    "Realism\n15%",
    "Cubism\n10%",
    "Surrealism\n5%",
    "Others\n3%",
]

# Pie chart data for visitor preferences by art style
sizes_pie = [50, 20, 15, 10, 5]
labels_pie = ["Abstract", "Impressionism", "Realism", "Cubism", "Surrealism"]

title = "Visitor Preferences by Art Style"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors_treemap = ["#66c2a5", "#fc8d62", "#8da0cb", "#e78ac3", "#a6d854", "#ffd92f"]
colors_pie = ["#66c2a5", "#fc8d62", "#8da0cb", "#e78ac3", "#a6d854"]
explode_pie = (0.1, 0, 0, 0, 0)  # Highlight the first slice

# Create figure and set GridSpec
fig = plt.figure(figsize=(12, 6))
gs = GridSpec(1, 2, figure=fig)

# General title for the figure
fig.suptitle('Art Gallery Analysis', fontsize=16)

# Create treemap subplot
ax1 = fig.add_subplot(gs[0, 0])
squarify.plot(
    sizes=sizes_treemap,
    label=labels_treemap,
    color=colors_treemap,
    alpha=0.8,
    text_kwargs={"fontsize": 14, "weight": "bold"}
)
ax1.axis("off")  # Disable the axes
ax1.set_title("Artwork Distribution by Style", fontsize=14, pad=10)

# Create pie chart subplot
ax2 = fig.add_subplot(gs[0, 1])
wedges, texts, autotexts = ax2.pie(
    sizes_pie,
    explode=explode_pie,
    labels=labels_pie,
    colors=colors_pie,
    autopct="%1.1f%%",
    shadow=True,
    startangle=90,
    textprops={'fontsize': 12, 'weight': 'bold'}
)
ax2.set_title(title, fontsize=14, pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("multidiff_26.pdf", bbox_inches="tight")
