

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Religions for the pie chart
religions = [
    "Christianity",
    "Islam",
    "Hinduism",
    "Buddhism",
]
religion_proportions = [31.2, 24.1, 15.0, 6.9]

# Decades and follower growth for the scatter plot
decades = ["1980s", "1990s", "2000s", "2010s"]
years = [1980, 1990, 2000, 2010]
follower_growth = [20, 25, 30, 35]  # in millions

# Axes Limits and Labels
title_1 = "Global Distribution of Major Religions"
title_2 = "Growth of Religious Followers Over Decades"
xlabel_value = "Year"
ylabel_value = "Follower Growth (millions)"
ylim_values = [0, 40]
xlim_values = [1975, 2015]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and set up GridSpec
fig = plt.figure(figsize=(12, 6))
gs = gridspec.GridSpec(1, 2, width_ratios=[1, 1])

# Create pie chart on the left
ax1 = fig.add_subplot(gs[0])
wedges, texts, autotexts = ax1.pie(
    religion_proportions,
    labels=religions,
    autopct="%1.1f%%",
    startangle=90,
    colors=["#ffcc00", "#3399ff", "#33cc33", "#ff6666"],
)
ax1.set_title(title_1)

# Create scatter plot on the right
ax2 = fig.add_subplot(gs[1])
scatter = ax2.scatter(
    years,
    follower_growth,
    color="#007acc",
    s=np.array(follower_growth) * 10,  # scale marker size for better visibility
    alpha=0.7,
    edgecolor="black",
    marker='o',
)
ax2.set_title(title_2)
ax2.set_xlabel(xlabel_value)
ax2.set_ylabel(ylabel_value)
ax2.grid(True)
ax2.set_ylim(ylim_values)
ax2.set_xlim(xlim_values)

# Add text labels to scatter points
for i, txt in enumerate(decades):
    ax2.annotate(txt, (years[i], follower_growth[i] + 1))

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("multidiff_40.pdf", bbox_inches="tight")

