
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for the plots
import numpy as np

np.random.seed(1)

countries = [
    "Country A",
    "Country B",
    "Country C",
    "Country D",
    "Country E",
    "Country F"
]
co2_emissions = [12.5, 18.9, 22.3, 15.1, 19.7, 13.4]  # in million metric tons
water_usage = [350.2, 420.1, 398.6, 289.7, 315.3, 330.8]  # in billion liters
energy_consumption = [500.1, 620.5, 580.7, 470.3, 510.2, 530.8]  # in terawatt-hours

co2_diff = np.random.randn(6, 6) * 2
water_diff = np.random.randn(6, 6) * 20
energy_diff = np.random.randn(6, 6) * 30
resource_efficiency_diff = np.random.randn(6, 6) * 10

titles = [
    "CO2 Emissions (million metric tons)",
    "Water Usage (billion liters)",
    "CO2 Emission Differences",
    "Water Usage Differences",
    "Energy Consumption Differences",
    "Resource Efficiency Differences"
]
xlim1 = [0, 25]
xlim2 = [0, 500]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, axs = plt.subplots(2, 3, figsize=(12, 8))

# Plot CO2 Emissions
axs[0, 0].barh(countries, co2_emissions, color="#a1dab4")
axs[0, 0].set_title(titles[0])
axs[0, 0].set_xlim(xlim1)
axs[0, 0].invert_yaxis()  # Reverse the order for readability
# annotate the bars with the values
for i, v in enumerate(co2_emissions):
    axs[0, 0].text(v + 0.5, i, str(v), color="black", va="center")

# Plot Water Usage
axs[1, 0].barh(countries, water_usage, color="#41b6c4")
axs[1, 0].set_title(titles[1])
axs[1, 0].set_xlim(xlim2)
axs[1, 0].invert_yaxis()  # Reverse the order for readability
# annotate the bars with the values
for i, v in enumerate(water_usage):
    axs[1, 0].text(v + 10, i, str(v), color="black", va="center")

# Plot CO2 Emission Differences
im1 = axs[0, 1].imshow(co2_diff, cmap="RdYlBu", aspect="auto")
axs[0, 1].set_title(titles[2])
for i in range(len(countries)):
    for j in range(len(countries)):
        text = axs[0, 1].text(
            j,
            i,
            round(co2_diff[i, j], 2),
            ha="center",
            va="center",
            color="black" if abs(co2_diff[i, j]) < 1 else "white",
        )
axs[0, 1].axis("off")

# Plot Water Usage Differences
im2 = axs[1, 1].imshow(water_diff, cmap="RdYlBu", aspect="auto")
axs[1, 1].set_title(titles[3])
for i in range(len(countries)):
    for j in range(len(countries)):
        text = axs[1, 1].text(
            j,
            i,
            round(water_diff[i, j], 2),
            ha="center",
            va="center",
            color="black" if abs(water_diff[i, j]) < 10 else "white",
        )
axs[1, 1].axis("off")

# Plot Energy Consumption Differences
im3 = axs[0, 2].imshow(energy_diff, cmap="RdYlBu", aspect="auto")
axs[0, 2].set_title(titles[4])
for i in range(len(countries)):
    for j in range(len(countries)):
        text = axs[0, 2].text(
            j,
            i,
            round(energy_diff[i, j], 2),
            ha="center",
            va="center",
            color="black" if abs(energy_diff[i, j]) < 15 else "white",
        )
axs[0, 2].axis("off")

# Plot Resource Efficiency Differences
im4 = axs[1, 2].imshow(resource_efficiency_diff, cmap="RdYlBu", aspect="auto")
axs[1, 2].set_title(titles[5])
for i in range(len(countries)):
    for j in range(len(countries)):
        text = axs[1, 2].text(
            j,
            i,
            round(resource_efficiency_diff[i, j], 2),
            ha="center",
            va="center",
            color="black" if abs(resource_efficiency_diff[i, j]) < 5 else "white",
        )
axs[1, 2].axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("multidiff_45.pdf", bbox_inches="tight")
