

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Assuming data values for the bar chart
continents = [
    "Asia",
    "Africa",
    "Europe",
    "North America",
    "South America",
    "Oceania",
]
temperature_increases = [1.2, 1.1, 1.3, 1.5, 1.4, 1.0]

# Generate y values for the line chart with a trend over 26 years
years = np.arange(1995, 2021)
asia_co2 = np.linspace(300, 410, 26) + np.random.normal(0, 5, 26)
africa_co2 = np.linspace(305, 420, 26) + np.random.normal(0, 5, 26)
europe_co2 = np.linspace(290, 400, 26) + np.random.normal(0, 5, 26)
north_america_co2 = np.linspace(295, 405, 26) + np.random.normal(0, 5, 26)
south_america_co2 = np.linspace(310, 430, 26) + np.random.normal(0, 5, 26)
oceania_co2 = np.linspace(285, 395, 26) + np.random.normal(0, 5, 26)

# Axes Limits and Labels
xlabel_value_1 = "Temperature Increase (°C)"
xlim_values_1 = [0, 2]
xticks_all_1 = np.arange(0, 2.05, 0.1)
xticks_labeled_1 = np.arange(0, 2.1, 0.5)

xlabel_value_2 = "Years"
ylabel_value_2 = "CO2 Concentration (ppm)"
ylim_values_2 = [280, 440]
xticks_all_2 = np.arange(1995, 2021, 1)
xticks_labeled_2 = np.arange(1995, 2026, 5)

# Labels for line chart
label_Asia = "Asia"
label_Africa = "Africa"
label_Europe = "Europe"
label_NorthAmerica = "North America"
label_SouthAmerica = "South America"
label_Oceania = "Oceania"

title=["Average Temperature Increase by Continent", "CO2 Concentration Over Time by Continent"]
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create bar chart
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 12))
bar_colors = ['#ff9999','#66b3ff','#99ff99','#ffcc99','#c2c2f0','#ffb3e6']
ax1.barh(continents, temperature_increases, color=bar_colors)
ax1.set_xlabel(xlabel_value_1)
ax1.set_xlim(xlim_values_1)

# Add more x-ticks but only label some of them
all_xticks = xticks_all_1
labeled_xticks = xticks_labeled_1
ax1.set_xticks(all_xticks)
ax1.set_xticklabels(
    [f"{tick:.1f}" if tick in labeled_xticks else "" for tick in all_xticks]
)
ax1.set_title(title[0])

# Create line chart
ax2.plot(years, asia_co2, label=label_Asia, color="#ff9999", linestyle='-')
ax2.plot(years, africa_co2, label=label_Africa, color="#66b3ff", linestyle='--')
ax2.plot(years, europe_co2, label=label_Europe, color="#99ff99", linestyle='-.')
ax2.plot(years, north_america_co2, label=label_NorthAmerica, color="#ffcc99", linestyle=':')
ax2.plot(years, south_america_co2, label=label_SouthAmerica, color="#c2c2f0", linestyle=(0, (3, 1, 1, 1)))
ax2.plot(years, oceania_co2, label=label_Oceania, color="#ffb3e6", linestyle='-')

ax2.set_xlabel(xlabel_value_2)
ax2.set_ylabel(ylabel_value_2)

# Set the y limit
ax2.set_ylim(ylim_values_2)
ax2.legend(loc="upper right", frameon=False)
all_xticks = xticks_all_2
labeled_xticks = xticks_labeled_2
ax2.set_xticks(all_xticks)
ax2.set_xticklabels(
    [f"{tick}" if tick in labeled_xticks else "" for tick in all_xticks]
)
ax2.set_title(title[1])

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("multidiff_48.pdf", bbox_inches="tight")

