

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Assuming data values for the bar chart
crops = [
    "Wheat",
    "Rice",
    "Maize",
    "Barley",
    "Soybean",
    "Potato",
]
yields = [3.2, 2.9, 3.5, 3.0, 2.7, 4.0]  # in tons per hectare

# Generate y values for the line chart with simulated yearly yield counts
years = np.arange(2010, 2021)
wheat_yield = np.linspace(3.5, 4.1, 11) + np.random.normal(0, 0.2, 11)
rice_yield = np.linspace(2.8, 3.4, 11) + np.random.normal(0, 0.2, 11)
maize_yield = np.linspace(3.0, 3.8, 11) + np.random.normal(0, 0.2, 11)
barley_yield = np.linspace(2.5, 3.2, 11) + np.random.normal(0, 0.2, 11)
soybean_yield = np.linspace(2.0, 2.9, 11) + np.random.normal(0, 0.2, 11)
potato_yield = np.linspace(3.8, 4.5, 11) + np.random.normal(0, 0.2, 11)

# Axes Limits and Labels
xlabel_value_1 = "Yield (Tons per Hectare)"
xlim_values_1 = [0, 5]
xticks_all_1 = np.arange(0, 5.5, 0.5)
xticks_labeled_1 = np.arange(0, 6, 1)

xticks_2 = np.arange(2010, 2021)
label_Wheat = "Wheat"
label_Rice = "Rice"
label_Maize = "Maize"
label_Barley = "Barley"
label_Soybean = "Soybean"
label_Potato = "Potato"
xlabel_value_2 = "Year"
ylabel_value_2 = "Yield (Tons)"
ylim_values_2 = [0, 5]
xticks_all_2 = np.arange(2010, 2021, 1)
xticks_labeled_2 = np.arange(2010, 2021, 2)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create bar chart
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 12))
ax1.barh(crops, yields, color=["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b"])
ax1.set_xlabel(xlabel_value_1)
ax1.set_xlim(xlim_values_1)

# Add more x-ticks but only label some of them
all_xticks = xticks_all_1
labeled_xticks = xticks_labeled_1
ax1.set_xticks(all_xticks)
ax1.set_xticklabels(
    [f"{tick:.1f}" if tick in labeled_xticks else "" for tick in all_xticks]
)

# Create line chart
ax2.plot(years, wheat_yield, label=label_Wheat, color="skyblue", marker='o')
ax2.plot(years, rice_yield, label=label_Rice, color="coral", marker='s')
ax2.plot(years, maize_yield, label=label_Maize, color="forestgreen", marker='x')
ax2.plot(years, barley_yield, label=label_Barley, color="gold", linestyle="--", marker='D')
ax2.plot(years, soybean_yield, label=label_Soybean, color="darkred", linestyle=":", marker='^')
ax2.plot(years, potato_yield, label=label_Potato, color="darkorchid", linestyle="-.", marker='v')
ax2.set_xlabel(xlabel_value_2)
ax2.set_ylabel(ylabel_value_2)

# Set the y limit to match the uploaded image aspect
ax2.set_ylim(ylim_values_2)
ax2.legend(loc="upper right", frameon=False)
all_xticks = xticks_all_2
labeled_xticks = xticks_labeled_2
ax2.set_xticks(all_xticks)
ax2.set_xticklabels(
    [f"{tick}" if tick in labeled_xticks else "" for tick in all_xticks]
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("multidiff_49.pdf", bbox_inches="tight")

