
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for the bar chart
platforms = [
    "Platform A (P1)",
    "Platform B (P2)",
    "Platform C (P3)",
    "Platform D (P4)",
    "Platform E (P5)",
    "Platform F (P6)",
    "Platform G (P7)",
]
course_count = [350, 300, 250, 400, 375, 320, 280]

# Data for the heatmap (Cross-Enrollments Matrix)
cross_enrollments = np.array(
    [
        [0, 50, 70, 30, 45, 85, 95],
        [40, 0, 60, 55, 70, 80, 75],
        [35, 75, 0, 45, 25, 90, 85],
        [50, 65, 80, 0, 55, 60, 88],
        [30, 45, 50, 40, 0, 35, 60],
        [55, 85, 95, 75, 60, 0, 100],
        [70, 90, 85, 60, 80, 85, 0],
    ]
)

# Text Labels
ax1title = "Course Counts per Platform"
ax2title = "Cross-Enrollments Matrix"
ax1xlim = [0, 450]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(
    1, 2, figsize=(12, 7), gridspec_kw={"width_ratios": [1, 1.25]}
)

# Bar chart
bar_color = "#1f77b4"
y_pos = np.arange(len(platforms))
ax1.barh(y_pos, course_count, color=bar_color)
ax1.set_yticks(y_pos)
ax1.set_yticklabels(platforms, fontsize=10)
ax1.invert_yaxis()  # labels read top-to-bottom
ax1.set_title(ax1title, fontsize=14)
ax1.set_xlim(ax1xlim)
for i, v in enumerate(course_count):
    ax1.text(v + 5, i, str(v), color="black", va="center", fontsize=10)

# Heatmap
cmap = "Blues"
im = ax2.imshow(cross_enrollments, cmap=cmap, aspect="auto")

# We want to show all ticks...
ax2.set_xticks(np.arange(len(platforms)))
ax2.set_yticks(np.arange(len(platforms)))
# ... and label them with the respective list entries
ax2.set_xticklabels(platforms, fontsize=10)
ax2.set_yticklabels(platforms, fontsize=10)

# Rotate the tick labels and set their alignment.
plt.setp(ax2.get_xticklabels(), rotation=45, ha="right", rotation_mode="anchor")

# Loop over data dimensions and create text annotations.
for i in range(len(platforms)):
    for j in range(len(platforms)):
        text = ax2.text(
            j, i, "{:.0f}".format(cross_enrollments[i, j]), ha="center", va="center", color="black", fontsize=10
        )

ax2.set_title(ax2title, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("multidiff_58.pdf", bbox_inches="tight")
